% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_table_body.R
\name{modify_table_body}
\alias{modify_table_body}
\title{Modify Table Body}
\usage{
modify_table_body(x, fun, ...)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
A 'gtsummary' object}

\item{fun}{(\code{function})\cr
A function or formula. If a \emph{function}, it is used as is.
If a \emph{formula}, e.g. \code{fun = ~ .x |> arrange(variable)},
it is converted to a function. The argument passed to \code{fun} is \code{x$table_body}.}

\item{...}{Additional arguments passed on to the function}
}
\value{
A 'gtsummary' object
}
\description{
Function is for advanced manipulation of gtsummary tables.
It allow users to modify the \code{.$table_body} data frame included
in each gtsummary object.

If a new column is added to the table, default printing instructions will then
be added to \code{.$table_styling}. By default, columns are hidden.
To show a column, add a column header with \code{modify_header()} or call
\code{modify_column_unhide()}.
}
\examples{
# Example 1 --------------------------------
# Add number of cases and controls to regression table
trial |>
 tbl_uvregression(
   y = response,
   include = c(age, marker),
   method = glm,
   method.args = list(family = binomial),
   exponentiate = TRUE,
   hide_n = TRUE
 ) |>
 # adding number of non-events to table
 modify_table_body(
   ~ .x \%>\%
     dplyr::mutate(N_nonevent = N_obs - N_event) |>
     dplyr::relocate(c(N_event, N_nonevent), .before = estimate)
 ) |>
 # assigning header labels
 modify_header(N_nonevent = "**Control N**", N_event = "**Case N**") |>
 modify_fmt_fun(c(N_event, N_nonevent) ~ style_number)
}
