
# gtfstools

[![CRAN
status](https://www.r-pkg.org/badges/version/gtfstools)](https://CRAN.R-project.org/package=gtfstools)
[![B
status](https://github.com/ipeaGIT/gtfstools/workflows/R-CMD-check/badge.svg)](https://github.com/ipeaGIT/gtfstools/actions?query=workflow%3AR-CMD-check)
[![Codecov test
coverage](https://codecov.io/gh/ipeaGIT/gtfstools/branch/master/graph/badge.svg)](https://codecov.io/gh/ipeaGIT/gtfstools?branch=master)
[![Lifecycle:
experimental](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html)

**gtfstools** offers a set of convenient tools for editing and analysing
transit feeds in GTFS format. Feeds are read as a `list` of
`data.table`s, allowing for easy and fast data manipulation. Many of
this package’s features are based on functions from other packages,
especially [`{tidytransit}`](https://github.com/r-transit/tidytransit)
and [`{gtfs2gps}`](https://github.com/ipeaGIT/gtfs2gps).

## Installation

Development version:

``` r
remotes::install_github("ipeaGIT/gtfstools")
```

This package requires a working installation of
[`{sf}`](https://github.com/r-spatial/sf). Please check [this
link](https://github.com/r-spatial/sf#installing) for more information
on how to install it.

## Usage

Please read the introductory vignette for some basic usage:
[Introduction to
gtfstools](https://ipeagit.github.io/gtfstools/articles/gtfstools.html).

## Related packages

-   [`{tidytransit}`](https://github.com/r-transit/tidytransit)
-   [`{gtfs2gps}`](https://github.com/ipeaGIT/gtfs2gps)
-   [`{gtfsrouter}`](https://github.com/ATFutures/gtfs-router)

## Acknowledgement <a href="https://www.ipea.gov.br"><img align="right" src="man/figures/ipea_logo.png" alt="IPEA" width="300" /></a>

**gtfstools** is developed by a team at the Institute for Applied
Economic Research (Ipea), Brazil.
