% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_ieqtls.R
\name{calculate_ieqtls}
\alias{calculate_ieqtls}
\title{Calculate Ieqtls}
\usage{
calculate_ieqtls(
  cellType,
  tissueSiteDetailId,
  gencodeId,
  variantId,
  datasetId = "gtex_v8"
)
}
\arguments{
\item{cellType}{String. "Adipocytes", "Epithelial_cells", "Hepatocytes",
"Keratinocytes", "Myocytes", "Neurons", "Neutrophils".}

\item{tissueSiteDetailId}{String. The ID of the tissue of interest. Can be a
GTEx specific ID (e.g. "Whole_Blood"; use \code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}}
to see valid values) or an Ontology ID.}

\item{gencodeId}{String. A Versioned GENCODE ID of a gene, e.g.
"ENSG00000065613.9".}

\item{variantId}{String. A gtex variant ID.}

\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}
}
\value{
A tibble.
}
\description{
Calculate your own Cell Specific eQTLs.
\itemize{
\item This service calculates the gene-variant association for any given pair of gene and variant, which may or may not be significant.
\item This requires as input a GENCODE ID, GTEx variant ID, and tissue site detail ID.
}

By default, the calculation is based on the latest GTEx release.

\href{https://gtexportal.org/api/v2/redoc#tag/Dynamic-Association-Endpoints/operation/calculate_ieqtls_api_v2_association_dynieqtl_get}{GTEx Portal API documentation}.
}
\examples{
\dontrun{
# perform request
calculate_ieqtls(cellType = "Adipocytes",
                 tissueSiteDetailId = "Adipose_Subcutaneous",
                 gencodeId = "ENSG00000203782.5",
                 variantId = "chr1_1099341_T_C_b38")
}
}
\seealso{
Other Dynamic Association Endpoints: 
\code{\link{calculate_expression_quantitative_trait_loci}()},
\code{\link{calculate_isqtls}()},
\code{\link{calculate_splicing_quantitative_trait_loci}()}
}
\concept{Dynamic Association Endpoints}
