% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topics.R
\name{fmts}
\alias{fmts}
\title{Formatting functions}
\description{
All formatting functions in gt are quite consistent. All functions that start
with the common \verb{fmt_*()} prefix have the following points in common
}
\details{
Let's use the \link{exibble} data for this.
}
\examples{
gt_tbl <- gt(exibble)

#
# They all have `columns` and `rows` to specify target cells and default to
# styling all compatible cells.
#
# By default, they apply styling to all compatible columns.

# Will style all numeric columns
gt_tbl \%>\% fmt_number()

# will style the time column
gt_tbl \%>\% fmt_time(columns = time)

# Will style nothing since is only compatible with logical values
gt_tbl \%>\% fmt_tf()

#
# Their order has importance as the last styling will have priority.
#

# Will style all numeric columns as integer
# fmt_number() will have no effect
gt_tbl \%>\% fmt_number() \%>\% fmt_integer()

#
# Therefore, to apply different styling, it is important to specify columns or rows.
#

# Will style all numeric columns as number and as currency the currency column.
# fmt_number() will have no effect
gt_tbl \%>\% fmt_number() \%>\% fmt_integer(currency)
}
