% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refinedBoundaries.R
\name{ldSecControl}
\alias{ldSecControl}
\title{Difference between the Error Rate and Significance Level, the Error Spending Approach}
\usage{
ldSecControl(ap, alpha, cvec, tVec, ExtrmLoc, type = 2)
}
\arguments{
\item{ap}{significance level for the primary endpoint}

\item{alpha}{targeted significance level for the secondary endpoint}

\item{cvec}{a vector of calculated primary boundaries}

\item{tVec}{a vector of information, gammaVec = sqrt(tVec)}

\item{ExtrmLoc}{an integer between 1 and K, locate the maximum of type I error of secondary endpoint}

\item{type}{type of sequential procedures. Type 1 OBF d, Type 2 POC d.}
}
\value{
difference between alpha and the calculated error rate.
}
\description{
Calculate the difference between the error rate and significance level for the secondary endpoint, Lan-DeMets error spending approach.
}
\references{
Lan, K. K. G., and Demets, D. L. (1983). Discrete sequential boundaries for clinical trials. \emph{Biometrika} \bold{70}, 659-663.

 Tamhane, A. C., Gou, J., Jennison, C., Mehta, C. R., and Curto, T. (2018). A gatekeeping procedure to test a primary and a secondary endpoint in a group sequential design with multiple interim looks. \emph{Biometrics}, 74(1), 40-48.
}
\seealso{
\code{secControl}
}
\author{
Jiangtao Gou
}
