% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refinedBoundaries.R
\name{p.adjust.gtxr}
\alias{p.adjust.gtxr}
\title{Adjust P-values for Multiple Test Procedures}
\usage{
p.adjust.gtxr(p, method = "gtxr", n = length(p))
}
\arguments{
\item{p}{vector of p-values.}

\item{method}{multiplicity correction method, "gtxr" is the hybrid Hochberg–Hommel method, other methods include: "gtxr", "holm", "hochberg", "hommel", "bonferroni", "BH", "BY","fdr", "none".}

\item{n}{number of p-values.}
}
\value{
a vector of corrected p-values.
}
\description{
Given a set of p-values, returns adjusted p-values, including the hybrid Hochberg–Hommel procedure (Gou et al., 2014).
}
\details{
#


Given a set of p-values, returns p-values adjusted using one of several methods. The default method is "gtxr". Other adjustment methods have been included in function p.adjust in R package stats.
}
\examples{
 pvalues.raw <- c(0.002,0.007,0.005,0.024,0.022,0.009,0.007,0.036,0.060,0.035)
 p.adj <- p.adjust.gtxr(pvalues.raw, method = "gtxr")
}
\references{
Gou, J., Tamhane, A. C., Xi, D., and Rom. D. (2014). A class of improved hybrid Hochberg-Hommel type step-up multiple test procedures. \emph{Biometrika} \bold{101}, 899-911.
}
\seealso{
\code{p.adjust}
}
\author{
Jiangtao Gou
}
