% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{segm}
\alias{segm}
\title{Segmentation of R ratio values}
\usage{
segm(dat)
}
\arguments{
\item{dat}{List object, containing at least two matrices "baf" and "rratio" and two vectors "chr" and "pos".}
}
\value{
norm_data object including a CNA object.
}
\description{
Wrapper for \code{DNAcopy::segment}.
Other methods (e.g. sliding window approaches) might be added in a future version.
}
\examples{
\dontrun{
if(require(brassicaData)){
data("raw_napus", package = "brassicaData", envir = environment())
dat <- intens_theta(raw_napus)
dat <- remove_suffix(dat, "_Grn")
dat <- geno_baf_rratio(dat, delthresh = 11)
dat <- segm(dat)
}
}
}

