% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_beta.R
\name{update_beta}
\alias{update_beta}
\title{Update Beta}
\usage{
update_beta(alpha, beta, priors = list())
}
\arguments{
\item{alpha}{Double value for alpha (count of successes). Must be 0 or greater.}

\item{beta}{Double value for beta (count of failures). Must be 0 or greater.}

\item{priors}{An optional list object that contains alpha0 and
beta0. Otherwise the function with use Beta(1,1) as the prior distribution.}
}
\value{
A tibble object that contains `alpha` and `beta`
}
\description{
Updates Beta Distribution with the Beta-Bernoulli
conjugate prior update rule
}
\examples{
update_beta(alpha = 1, beta = 5, priors = list(alpha0 = 2, beta0 = 2))
update_beta(alpha = 20000, beta = 50000)

}
