% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_win_prob.R
\name{estimate_win_prob}
\alias{estimate_win_prob}
\title{Estimate Win Probability}
\usage{
estimate_win_prob(input_df, distribution, priors = list())
}
\arguments{
\item{input_df}{Dataframe containing option_name (str) and various other columns
depending on the distribution type. See vignette for more details.}

\item{distribution}{String of the distribution name}

\item{priors}{Optional list of priors. Defaults will be use otherwise.}
}
\value{
tibble object with 2 columns: `option_name`
    and `win_probability` formatted as a percent
}
\description{
Creates a tibble of win probabilities for each option based on the data observed.
}
\examples{
input_df <- tibble::tibble(
   option_name = c("A", "B"),
   sum_clicks = c(1000, 1000),
   sum_conversions = c(100, 120)
)
estimate_win_prob(input_df, "conversion_rate")

}
