% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.grf_tree}
\alias{plot.grf_tree}
\title{Plot a GRF tree object.}
\usage{
\method{plot}{grf_tree}(x, ...)
}
\arguments{
\item{x}{The tree to plot}

\item{...}{Additional arguments (currently ignored).}
}
\description{
Plot a GRF tree object.
}
\examples{
\dontrun{
# Save the plot of a tree in the causal forest.
install.packages("DiagrammeR")
install.packages("DiagrammeRsvg")
n <- 500
p <- 10
X <- matrix(rnorm(n * p), n, p)
W <- rbinom(n, 1, 0.5)
Y <- pmax(X[, 1], 0) * W + X[, 2] + pmin(X[, 3], 0) + rnorm(n)
c.forest <- causal_forest(X, Y, W)
#save the first tree in the forest as plot.svg
tree.plot = plot(get_tree(c.forest, 1))
cat(DiagrammeRsvg::export_svg(tree.plot), file='plot.svg')
}
}
