% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning.R
\name{tune_forest}
\alias{tune_forest}
\title{Tune a forests}
\usage{
tune_forest(data, nrow.X, ncol.X, args, tune.parameters,
  tune.parameters.defaults, num.fit.trees, num.fit.reps, num.optimize.reps,
  train, predict_oob, predict.data.args)
}
\arguments{
\item{data}{The data arguments (output from create_data_matrices) for the forest.}

\item{nrow.X}{The number of observations.}

\item{ncol.X}{The number of variables.}

\item{args}{The remaining call arguments for the forest.}

\item{tune.parameters}{The vector of parameter names to tune.}

\item{tune.parameters.defaults}{The grf default values for the vector of parameter names to tune.}

\item{num.fit.trees}{The number of trees in each 'mini forest' used to fit the tuning model.}

\item{num.fit.reps}{The number of forests used to fit the tuning model.}

\item{num.optimize.reps}{The number of random parameter values considered when using the model
to select the optimal parameters.}

\item{train}{The grf forest training function.}

\item{predict_oob}{The grf forest oob prediction function.}

\item{predict.data.args}{The names of the arguments in data passed to predict_oob.}
}
\value{
tuning output
}
\description{
Finds the optimal parameters to be used in training a forest.
}
