% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_forest.R
\name{custom_forest}
\alias{custom_forest}
\title{Custom forest}
\usage{
custom_forest(X, Y, sample.fraction = 0.5, mtry = NULL, num.trees = 2000,
  num.threads = NULL, min.node.size = NULL, honesty = TRUE,
  honesty.fraction = NULL, alpha = 0.05, imbalance.penalty = 0,
  seed = NULL, clusters = NULL, samples_per_cluster = NULL)
}
\arguments{
\item{X}{The covariates used in the regression.}

\item{Y}{The outcome.}

\item{sample.fraction}{Fraction of the data used to build each tree.
Note: If honesty = TRUE, these subsamples will
further be cut by a factor of honesty.fraction.}

\item{mtry}{Number of variables tried for each split.}

\item{num.trees}{Number of trees grown in the forest. Note: Getting accurate
confidence intervals generally requires more trees than
getting accurate predictions.}

\item{num.threads}{Number of threads used in training. If set to NULL, the software
automatically selects an appropriate amount.}

\item{min.node.size}{A target for the minimum number of observations in each tree leaf. Note that nodes
with size smaller than min.node.size can occur, as in the original randomForest package.}

\item{honesty}{Whether to use honest splitting (i.e., sub-sample splitting).}

\item{honesty.fraction}{The fraction of data that will be used for determining splits if honesty = TRUE. Corresponds 
to set J1 in the notation of the paper. When using the defaults (honesty = TRUE and 
honesty.fraction = NULL), half of the data will be used for determining splits}

\item{alpha}{A tuning parameter that controls the maximum imbalance of a split.}

\item{imbalance.penalty}{A tuning parameter that controls how harshly imbalanced splits are penalized.}

\item{seed}{The seed for the C++ random number generator.}

\item{clusters}{Vector of integers or factors specifying which cluster each observation corresponds to.}

\item{samples_per_cluster}{If sampling by cluster, the number of observations to be sampled from
each cluster. Must be less than the size of the smallest cluster. If set to NULL
software will set this value to the size of the smallest cluster.}
}
\value{
A trained regression forest object.
}
\description{
Trains a custom forest model.
}
\examples{
\dontrun{
# Train a custom forest.
n = 50; p = 10
X = matrix(rnorm(n*p), n, p)
Y = X[,1] * rnorm(n)
c.forest = custom_forest(X, Y)

# Predict using the forest.
X.test = matrix(0, 101, p)
X.test[,1] = seq(-2, 2, length.out = 101)
c.pred = predict(c.forest, X.test)
}

}
