% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_completions_main.R
\name{complete_Gamma}
\alias{complete_Gamma}
\title{Completion of Gamma matrices}
\usage{
complete_Gamma(Gamma, graph = NULL, ...)
}
\arguments{
\item{Gamma}{Numeric \dxd variogram matrix.}

\item{graph}{\code{NULL} or \code{\link[igraph:make_graph]{igraph::graph}} object. If \code{NULL}, the graph
is implied by non-edge entries in \code{Gamma} being \code{NA}. Must be connected, undirected.}

\item{...}{Further arguments passed to \code{\link[=complete_Gamma_general_split]{complete_Gamma_general_split()}} if \code{graph}
is not decomposable}
}
\value{
Completed \dxd variogram matrix.
}
\description{
Given a \code{graph} and a (partial) variogram matrix \code{Gamma}, returns a full
variogram matrix that agrees with \code{Gamma} in entries corresponding to edges
of \code{graph} and whose corresponding precision matrix, obtained by
\code{\link[=Gamma2Theta]{Gamma2Theta()}}, has zeros in entries corresponding to non-edges of \code{graph}.
For results on the existence and uniqueness of this completion, see
\insertCite{hen2022;textual}{graphicalExtremes}.
}
\details{
If \code{graph} is decomposable, \code{Gamma} only needs to be specified on
the edges of the graph, other entries are ignored.
If \code{graph} is not decomposable, the graphical completion algorithm requires
a fully specified (but non-graphical) variogram matrix \code{Gamma} to begin with.
If necessary, this initial completion is computed using \code{\link[edmcr:npf]{edmcr::npf()}}.
}
\examples{
## Block graph:
Gamma <- rbind(
  c(0, .5, NA, NA),
  c(.5, 0, 1, 1.5),
  c(NA, 1, 0, .8),
  c(NA, 1.5, .8, 0)
)

complete_Gamma(Gamma)

## Alternative representation of the same completion problem:
my_graph <- igraph::graph_from_adjacency_matrix(rbind(
  c(0, 1, 0, 0),
  c(1, 0, 1, 1),
  c(0, 1, 0, 1),
  c(0, 1, 1, 0)
), mode = "undirected")
Gamma_vec <- c(.5, 1, 1.5, .8)
complete_Gamma(Gamma_vec, my_graph)

## Decomposable graph:
G <- rbind(
c(0, 5, 7, 6, NA),
c(5, 0, 14, 15, NA),
c(7, 14, 0, 5, 5),
c(6, 15, 5, 0, 6),
c(NA, NA, 5, 6, 0)
)

complete_Gamma(G)

## Non-decomposable graph:
G <- rbind(
c(0, 5, 7, 6, 6),
c(5, 0, 14, 15, 13),
c(7, 14, 0, 5, 5),
c(6, 15, 5, 0, 6),
c(6, 13, 5, 6, 0)
)
g <- igraph::make_ring(5)

complete_Gamma(G, g)


}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=Gamma2Theta]{Gamma2Theta()}}

Other matrix completion related topics:
\code{\link{complete_Gamma_decomposable}()},
\code{\link{complete_Gamma_general_demo}()},
\code{\link{complete_Gamma_general_split}()},
\code{\link{complete_Gamma_general}()}
}
\concept{matrixCompletions}
