% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_param.R
\name{fmpareto_graph_HR}
\alias{fmpareto_graph_HR}
\title{Parameter fitting for Huesler--Reiss graphical models}
\usage{
fmpareto_graph_HR(
  data,
  graph,
  p = NULL,
  method = c("vario", "ML"),
  handleCliques = c("average", "full", "sequential"),
  ...
)
}
\arguments{
\item{data}{Numeric \nxd matrix, where \code{n} is the
number of observations and \code{d} is the number of dimensions.}

\item{graph}{Undirected, connected [\code{igraph::graph}] object with \code{d} vertices,
representing the graphical structure of the fitted Huesler--Reiss model.}

\item{p}{Numeric between 0 and 1 or \code{NULL}. If \code{NULL} (default),
it is assumed that the \code{data} is already on a multivariate Pareto scale.
Else, \code{p} is used as the probability in the function \code{\link[=data2mpareto]{data2mpareto()}}
to standardize the \code{data}.}

\item{method}{One of \code{c('vario', 'ML')}, with \code{'vario'} as default, indicating
the method to be used for parameter estimation. See details.}

\item{handleCliques}{How to handle cliques and separators in the graph.
See details.}

\item{...}{Arguments passed to \code{\link[=fmpareto_HR_MLE]{fmpareto_HR_MLE()}}. Currently \code{cens}, \code{maxit},
\code{optMethod}, and \code{useTheta} are supported.}
}
\value{
The estiamted parameter matrix.
}
\description{
Fits the parameter matrix (variogram) of a multivariate Huesler--Reiss Pareto distirubtion
with a given graphical structure, using maximum-likelihood estimation
or the empirical variogram.
}
\details{
If \code{handleCliques='average'}, the marginal parameter matrix is estimated for
each maximal clique of the \code{graph} and then combined into a partial parameter
matrix by taking the average of entries from overlapping cliques. Lastly,
the full parameter matrix is computed using \code{\link[=complete_Gamma]{complete_Gamma()}}.

If \code{handleCliques='full'}, first the full parameter matrix is estimated using the
specified \code{method} and then the non-edge entries are adjusted such that the
final parameter matrix has the graphical structure indicated by \code{graph}.

If \code{handleCliques='sequential'}, \code{graph} must be decomposable, and
\code{method='ML'} must be specified. The parameter matrix is first estimated on
the (recursive) separators and then on the rest of the cliques, keeping
previously estimated entries fixed.

If \code{method='ML'}, the computational cost is mostly influenced by the total size
of the graph (if \code{handleCliques='full'}) or the size of the cliques,
and can already take a significant amount of time for modest dimensions (e.g. \code{d=3}).
}
