% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flight_plotting.R
\name{flightCountMatrixToConnectionList}
\alias{flightCountMatrixToConnectionList}
\title{Convert flight counts to connection list}
\usage{
flightCountMatrixToConnectionList(nFlightsPerConnection, directed = TRUE)
}
\arguments{
\item{nFlightsPerConnection}{A square, numeric matrix with identical column- and row-names.
Each entry represents the number of flights from the airport indexing the row to
the airport indexing the column in some arbitrary time period.}

\item{directed}{Logical scalar. Whether flights A->B and B->A should be considered separately.}
}
\value{
A data frame with columns \code{departureAirport}, \code{arrivalAirport}, \code{nFlights}.
Each row represents one connection with >=1 flights in the input matrix.
}
\description{
Convert a numeric matrix containing flight counts between ariports to a data
frame containing a list of connections.
}
