% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphdf.R
\docType{methods}
\name{graphdf}
\alias{graphdf}
\alias{graphdf,list-method}
\alias{graphdf,goc-method}
\alias{graphdf,grain-method}
\alias{graphdf,mpg-method}
\alias{graphdf,igraph-method}
\title{Produce a \code{data.frame} containing the structure and associated attributes}
\usage{
graphdf(x, ...)

\S4method{graphdf}{list}(x, ...)

\S4method{graphdf}{goc}(x, ...)

\S4method{graphdf}{grain}(x, ...)

\S4method{graphdf}{mpg}(x, ...)

\S4method{graphdf}{igraph}(x, ...)
}
\arguments{
\item{x}{A \code{goc}, \code{mpg}, \code{igraph}, or \code{list} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A list object containing:

\describe{
  \item{\code{v}}{node (vertex) names and associated attributes;}

  \item{\code{e}}{link (edge) lists and associated attributes.}
}

Please see \code{\link{MPG}} and \code{\link{GOC}} for details about the attributes.

For \code{\link{GOC}} objects which typically contain multiple thresholds,
an enumerated list of the same length as the number of thresholds is returned
each containing \code{v} and \code{e} elements.
}
\description{
Produce a \code{data.frame} containing the node (vertex) and link (edge)
structure as well as the associated attributes for these.
This provides an easy way to create data tables describing graphs, particularly
helpful for users unfamiliar with the structure of \code{igraph} objects.
}
\examples{
## Load raster landscape
tiny <- raster::raster(system.file("extdata/tiny.asc", package = "grainscape"))

## Create a resistance surface from a raster using an is-becomes reclassification
tinyCost <- raster::reclassify(tiny, rcl = cbind(c(1, 2, 3, 4), c(1, 5, 10, 12)))

## Produce a patch-based MPG where patches are resistance features=1
tinyPatchMPG <- MPG(cost = tinyCost, patch = tinyCost == 1)

## Extract a representative subset of 5 grains of connectivity
tinyPatchGOC <- GOC(tinyPatchMPG, nThresh = 5)

## Create a data.frame with the structure and attributes of a MPG object
tinyPatchMPG_df <- graphdf(tinyPatchMPG)

## Create a data.frame with the structure and attributes of a GOC object
tinyPatchGOC_df <- graphdf(tinyPatchGOC)

## Create a data.frame with the structure and attributes of any igraph object
graphdf(tinyPatchGOC@th[[1]]$goc)
}
\seealso{
\code{\link{MPG}}, \code{\link{GOC}}
}
\author{
Paul Galpern and Alex Chubaty
}
