% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_chat_style.R
\name{style_chat_history}
\alias{style_chat_history}
\title{Style Chat History}
\usage{
style_chat_history(history, ide_colors = get_ide_theme_info())
}
\arguments{
\item{history}{A list of chat messages with elements containing 'role' and
'content'.}

\item{ide_colors}{List containing the colors of the IDE theme.}
}
\value{
A list of formatted chat messages with styling applied, excluding
system messages.
}
\description{
This function processes the chat history, filters out system messages, and
formats the remaining messages with appropriate styling.
}
\examples{
chat_history_example <- list(
  list(role = "user", content = "Hello, World!"),
  list(role = "system", content = "System message"),
  list(role = "assistant", content = "Hi, how can I help?")
)

\dontrun{
style_chat_history(chat_history_example)
}
}
