% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai_api_calls.R
\name{openai_create_completion}
\alias{openai_create_completion}
\title{Generate text completions using OpenAI's API}
\usage{
openai_create_completion(
  model = "text_davinci-003",
  prompt = "<|endoftext|>",
  suffix = NULL,
  max_tokens = 16,
  temperature = NULL,
  top_p = NULL,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  task = "completions"
)
}
\arguments{
\item{model}{The model to use for generating text}

\item{prompt}{The prompt for generating completions}

\item{suffix}{The suffix for generating completions. If \code{NULL}, no suffix
will be used.}

\item{max_tokens}{The maximum number of tokens to generate.}

\item{temperature}{The temperature to use for generating text (between 0 and
1). If \code{NULL}, the default temperature will be used. It is recommended NOT
to specify temperature and top_p at a time.}

\item{top_p}{The top-p value to use for generating text (between 0 and 1). If
\code{NULL}, the default top-p value will be used. It is recommended NOT to
specify temperature and top_p at a time.}

\item{openai_api_key}{The API key for accessing OpenAI's API. By default, the
function will try to use the \code{OPENAI_API_KEY} environment variable.}

\item{task}{The task that specifies the API url to use, defaults to
"completions" and "chat/completions" is required for ChatGPT model.}
}
\value{
A list with the generated completions and other information returned
by the API.
}
\description{
Generate text completions using OpenAI's API
}
\examples{
\dontrun{
openai_create_completion(
  model = "text-davinci-002",
  prompt = "Hello world!"
)
}
}
