% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{nPreds}
\alias{nPreds}
\title{Number of Predictors}
\usage{
nPreds(gpModel)
}
\arguments{
\item{gpModel}{object of class GPPM.}
}
\value{
Number of predictors as numeric.
}
\description{
Extracts the number of predictors from a GPPM.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm('muI+muS*t','varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma',
        demoLGCM,'ID','y')
numberPreds <- nPreds(lgcm)
}
}
\seealso{
Other functions to extract from a GPPM: \code{\link{SE}},
  \code{\link{coef.GPPM}}, \code{\link{confint.GPPM}},
  \code{\link{covf}}, \code{\link{datas}},
  \code{\link{fitted.GPPM}}, \code{\link{getIntern}},
  \code{\link{logLik.GPPM}}, \code{\link{maxnObs}},
  \code{\link{meanf}}, \code{\link{nObs}},
  \code{\link{nPars}}, \code{\link{nPers}},
  \code{\link{parEsts}}, \code{\link{pars}},
  \code{\link{preds}}, \code{\link{vcov.GPPM}}
}
