% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{logLik.GPPM}
\alias{logLik.GPPM}
\title{Log-Likelihood}
\usage{
\method{logLik}{GPPM}(object, ...)
}
\arguments{
\item{object}{object of class GPPM. Must be fitted, that is, a result from \code{\link{fit.GPPM}}.}

\item{...}{additional arguments (currently not used).}
}
\value{
Returns an object of class logLik. Attributes are: "df" (\strong{d}egrees of \strong{f}reedom; number of estimated parameters in the model) and nobs (number of persons in the model)
}
\description{
Compute the log-likelihood for a GPPM at the maximum likelihood parameter values.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm('muI+muS*t','varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma',
        demoLGCM,'ID','y')
lgcmFit <- fit(lgcm)
ll <- logLik(lgcmFit)
}
}
\seealso{
Other functions to extract from a GPPM: \code{\link{SE}},
  \code{\link{coef.GPPM}}, \code{\link{confint.GPPM}},
  \code{\link{covf}}, \code{\link{datas}},
  \code{\link{fitted.GPPM}}, \code{\link{getIntern}},
  \code{\link{maxnObs}}, \code{\link{meanf}},
  \code{\link{nObs}}, \code{\link{nPars}},
  \code{\link{nPers}}, \code{\link{nPreds}},
  \code{\link{parEsts}}, \code{\link{pars}},
  \code{\link{preds}}, \code{\link{vcov.GPPM}}
}
