% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/offset_prices.R
\name{back_period}
\alias{back_period}
\alias{base_period}
\title{Offset a vector prices or quantities}
\usage{
back_period(period, product = gl(1, length(period)), match_first = TRUE)

base_period(period, product = gl(1, length(period)), match_first = TRUE)
}
\arguments{
\item{period}{A factor, or something that can be coerced into one, that
gives the time period for each transaction. The ordering of time periods
follows the levels of \code{period} to agree with
\code{\link[=cut.Date]{cut()}}.}

\item{product}{A factor, or something that can be coerced into one, that
gives the product identifier for each transaction. The default is to assume
that all transactions are for the same product.}

\item{match_first}{Should products in the first period match with
themselves (the default)?}
}
\value{
Both functions return a numeric vector of indices for the back/base periods.
With \code{back_period()}, for all periods after the first, the resulting vector
gives the location of the corresponding product in the previous period.
With \code{base_period()}, the resulting vector gives the location of the
corresponding product in the first period. The locations are unchanged for
the first time period if \code{match_first = TRUE}, \code{NA} otherwise.
}
\description{
For each product, compute either the position of the previous period (back
period), or the position of the first period (base period). Useful when price
information is stored in a table.
}
\note{
By definition, there must be at most one transaction for each product
in each time period to determine a back/base period. If multiple transactions
correspond to a period-product pair, then the back/base period at a point in
time is always the first position for that product in the previous period.
}
\examples{
df <- data.frame(
  price = 1:6,
  product = factor(c("a", "b")),
  period = factor(c(1, 1, 2, 2, 3, 3))
)

with(df, back_period(period, product))

# Make period-over-period price relatives

with(df, price / price[back_period(period, product)])

# Make fixed-base price relatives

with(df, price / price[base_period(period, product)])

# Change the base period with relevel()

with(df, price / price[base_period(relevel(period, "2"), product)])

# Warning is given if the same product has multiple prices
# at any point in time

with(df, back_period(period))

}
\seealso{
\link{outliers} for common methods to detect outliers for price relatives.

\code{rs_pairs} in the \pkg{rsmatrix} package for making sales pairs.
}
