% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{quantity_index}
\alias{quantity_index}
\title{Quantity index operator}
\usage{
quantity_index(f)
}
\arguments{
\item{f}{A \link[=price_indexes]{price-index function}.}
}
\value{
A function like \code{f}, except that the role of prices/quantities is reversed.
}
\description{
Remaps price arguments into quantity argument (and vice versa) to turn a
price index into a quantity index.
}
\examples{
p1 <- price6[[3]]
p0 <- price6[[2]]
q1 <- quantity6[[3]]
q0 <- quantity6[[2]]

# Remap argument names to be quantities rather than prices

quantity_index(laspeyres_index)(q1 = q1, q0 = q0, p0 = p0)

laspeyres_index(p1 = q1, p0 = q0, q0 = p0)

# Works with the index_weights() functions, too

quantity_index(index_weights("Laspeyres"))(q0 = q0, p0 = p0)

}
\seealso{
Other operators: 
\code{\link{balanced}()},
\code{\link{grouped}()}
}
\concept{operators}
