% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.Dataset.R
\name{gpb.Dataset.set.categorical}
\alias{gpb.Dataset.set.categorical}
\title{Set categorical feature of \code{gpb.Dataset}}
\usage{
gpb.Dataset.set.categorical(dataset, categorical_feature)
}
\arguments{
\item{dataset}{object of class \code{gpb.Dataset}}

\item{categorical_feature}{categorical features. This can either be a character vector of feature
names or an integer vector with the indices of the features (e.g.
\code{c(1L, 10L)} to say "the first and tenth columns").}
}
\value{
the dataset you passed in
}
\description{
Set the categorical features of an \code{gpb.Dataset} object. Use this function
             to tell GPBoost which features should be treated as categorical.
}
\examples{
\donttest{
data(agaricus.train, package = "gpboost")
train <- agaricus.train
dtrain <- gpb.Dataset(train$data, label = train$label)
data_file <- tempfile(fileext = ".data")
gpb.Dataset.save(dtrain, data_file)
dtrain <- gpb.Dataset(data_file)
gpb.Dataset.set.categorical(dtrain, 1L:2L)
}
}
