% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gower.R
\name{gower_dist}
\alias{gower_dist}
\title{Gower's distance}
\usage{
gower_dist(x, y, pair_x = NULL, pair_y = NULL, eps = 1e-08,
  nthread = getOption("gd_num_thread"))
}
\arguments{
\item{x}{\code{[data.frame]}}

\item{y}{\code{[data.frame]}}

\item{pair_x}{\code{[numeric|character] (optional)} Columns in \code{x} used for comparison. 
See Details below.}

\item{pair_y}{\code{[numeric|character] (optional)} Columns in \code{y} used for comparison. 
See Details below.}

\item{eps}{= \code{[numeric] (optional)} Computed numbers (variable ranges) 
smaller than \code{eps} are treated as zero.}

\item{nthread}{Number of threads to use for parallelization. By default,
for a dual-core machine, 2 threads are used. For any other machine 
n-1 cores are used so your machine doesn't freeze during a big computation. 
The maximum nr of threads are determined from \code{omp::get_max_threads}.}
}
\value{
A \code{numeric} vector of length \code{max(nrow(x),nrow(y))}.
}
\description{
Compute Gower's distance, pairwise between records in two data sets \code{x} 
and \code{y}. Records from the smallest data set are recycled over.
}
\section{Details}{

There are three ways to specify which columns of \code{x} should be compared
with what columns of \code{y}. The first option is do give no specification. 
In that case columns with matching names will be used. The second option
is to use only the \code{pairs_y} argument, specifying for each column in \code{x}
in order, which column in \code{y} must be used to pair it with (use \code{0} 
to skip a column in \code{x}). The third option is to explicitly specify the
columns to be matched using \code{pair_x} and \code{pair_y}.
}

\section{Note}{

Gower (1971) originally defined a similarity measure (\eqn{s}, say)
with values ranging from 0 (completely dissimilar) to 1 (completely similar).
The distance returned here equals \eqn{1-s}.
}
\references{
Gower, John C. "A general coefficient of similarity and some of its 
properties." Biometrics (1971): 857-871.
}
\seealso{
\code{\link{gower_topn}}
}

