% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_make_raster_from_polygon.R
\name{gt_make_raster_from_polygon}
\alias{gt_make_raster_from_polygon}
\title{Make Google Traffic Raster Based on Polygon}
\usage{
gt_make_raster_from_polygon(
  polygon,
  zoom,
  google_key,
  height_width_max = 2000,
  height = NULL,
  width = NULL,
  webshot_delay = NULL,
  reduce_hw = 10,
  return_list_of_rasters = FALSE,
  mask_to_polygon = TRUE,
  print_progress = TRUE
)
}
\arguments{
\item{polygon}{Polygon (\code{sf} object or \code{SpatialPolygonsDataframe}) in WGS84 CRS}

\item{zoom}{Zoom level; integer from 0 to 20. For more information about how zoom levels correspond to pixel size, see \href{https://wiki.openstreetmap.org/wiki/Zoom_levels}{here}}

\item{google_key}{Google API key}

\item{height_width_max}{Maximum pixel height and width to check using for each API query (pixel length depends on zoom). If the same number of API queries can be made with a smaller height/width, the function will use a smaller height/width. If \code{height} and \code{width} are specified, that height and width will be used and \code{height_width_max} will be ignored. (Default: \code{2000})}

\item{height}{Height, in pixels, for each API query (pixel length depends on zoom). Enter a \code{height} to manually specify the height; otherwise, a height of \code{height_width_max} or smaller will be used.}

\item{width}{Pixel, in pixels, for each API query (pixel length depends on zoom). Enter a \code{width} to manually specify the width; otherwise, a width of \code{height_width_max} or smaller will be used.}

\item{webshot_delay}{How long to wait for Google traffic layer to render (in seconds). Larger height/widths require longer delay times. If \code{NULL}, the following delay time (in seconds) is used: \code{delay = max(height,width)/200}.}

\item{reduce_hw}{Number of pixels to reduce height/width by. Doing so creates some overlap between grids to ensure there is not blank space between tiles. (Default: \code{10}).}

\item{return_list_of_rasters}{Whether to return a list of raster tiles instead of mosaicing together. (Default: \code{FALSE}).}

\item{mask_to_polygon}{Whether to mask raster to \code{polygon}. (Default: \code{TRUE}).}

\item{print_progress}{Show progress for which grid / API query has been processed. (Default: \code{TRUE}).}
}
\value{
Returns a georeferenced raster. Raster pixels can contain the following values: 1 = no traffic; 2 = medium traffic; 3 = high traffic; 4 = heavy traffic.
}
\description{
Make a raster from Google traffic data, where each pixel has one of four values
indicating traffic volume (no traffic, light, moderate, and heavy).
}
\examples{
\dontrun{
## Grab polygon of Manhattan
us_sp <- raster::getData('GADM', country='USA', level=2)
ny_sp <- us_sp[us_sp$NAME_2 \%in\% "New York",]

## Make raster
r <- gt_make_raster_from_polygon(polygon    = ny_sp,
                                 height     = 2000,
                                 width      = 2000,
                                 zoom       = 16,
                                 google_key = "GOOGLE-KEY-HERE")
} 

}
