% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_make_raster.R
\name{gt_make_raster}
\alias{gt_make_raster}
\title{Make Google Traffic Raster}
\usage{
gt_make_raster(
  location,
  height,
  width,
  zoom,
  google_key,
  webshot_delay = NULL,
  print_progress = TRUE
)
}
\arguments{
\item{location}{Vector of latitude and longitude}

\item{height}{Height (in pixels; pixel length depends on zoom)}

\item{width}{Width (in pixels; pixel length depends on zoom)}

\item{zoom}{Zoom level; integer from 0 to 20. For more information, see \href{https://wiki.openstreetmap.org/wiki/Zoom_levels}{here}}

\item{google_key}{Google API key}

\item{webshot_delay}{How long to wait for Google traffic layer to render. Larger height/widths require longer delay times. If \code{NULL}, the following delay time (in seconds) is used: \code{delay = max(height,width)/200}.}

\item{print_progress}{Whether to print function progress (default: \code{TRUE})}
}
\value{
Returns a georeferenced raster. Raster pixels can contain the following values: 1 = no traffic; 2 = medium traffic; 3 = high traffic; 4 = heavy traffic.
}
\description{
Make a raster from Google traffic data, where each pixel has one of four values
indicating traffic volume (no traffic, light, moderate, and heavy).
}
\examples{
\dontrun{
r <- gt_make_raster(location   = c(40.712778, -74.006111),
                    height     = 1000,
                    width      = 1000,
                    zoom       = 16,
                    google_key = "GOOGLE-KEY-HERE")
}

}
