% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team_drive_get.R
\name{team_drive_get}
\alias{team_drive_get}
\title{Get Team Drives by name or id}
\usage{
team_drive_get(name = NULL, id = NULL, verbose = TRUE)
}
\arguments{
\item{name}{Character vector of names.  A character vector marked with
\code{\link[=as_id]{as_id()}} is treated as if it was provided via the \code{id} argument.}

\item{id}{Character vector of Team Drive ids or URLs (it is first processed
with \code{\link[=as_id]{as_id()}}). If both \code{name} and \code{id} are non-\code{NULL}, \code{id} is silently
ignored.}

\item{verbose}{Logical, indicating whether to print informative messages
(default \code{TRUE}).}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per item.
}
\description{
Retrieve metadata for Team Drives specified via name or id. Note
that Google Drive does NOT behave like your local file system:
\itemize{
\item You can get zero, one, or more Team Drives back for each name! Team Drive
names need not be unique.
}

Note: \href{https://gsuite.google.com/learning-center/products/drive/get-started-team-drive/}{Team Drives}
are only available to users of certain enhanced Google services, such as G
Suite Enterprise, G Suite Business, or G Suite for Education.
}
\examples{
\dontrun{
team_drive_get("my-awesome-team-drive")
team_drive_get(c("apple", "orange", "banana"))
team_drive_get(as_id("KCmiHLXUk9PVA-0AJNG"))
team_drive_get(as_id("https://drive.google.com/drive/u/0/folders/KCmiHLXUk9PVA-0AJNG"))
team_drive_get(id = "KCmiHLXUk9PVA-0AJNG")
team_drive_get(id = "https://drive.google.com/drive/u/0/folders/KCmiHLXUk9PVA-0AJNG")
}
}
