% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_get.R
\name{drive_get}
\alias{drive_get}
\title{Get Drive files by path or id}
\usage{
drive_get(path = NULL, id = NULL, team_drive = NULL, corpus = NULL,
  verbose = TRUE)
}
\arguments{
\item{path}{Character vector of path(s) to get. Use a trailing slash to
indicate explicitly that a path is a folder, which can disambiguate if
there is a file of the same name (yes this is possible on Drive!). A
character vector marked with \code{\link[=as_id]{as_id()}} is treated as if it was provided via
the \code{id} argument.}

\item{id}{Character vector of Drive file ids or URLs (it is first processed
with \code{\link[=as_id]{as_id()}}). If both \code{path} and \code{id} are non-\code{NULL}, \code{id} is silently
ignored.}

\item{team_drive}{Anything that identifies one specific Team Drive: its name,
its id or URL marked with \code{\link[=as_id]{as_id()}}, or a \code{\link{dribble}}. Is pre-processed
with \code{\link[=as_team_drive]{as_team_drive()}}.  Read more about \link[=team_drives]{Team Drives}.}

\item{corpus}{Character, specifying the search collection. Only relevant in
the Team Drives context. If specified, must be one of \code{"user"}, \code{"all"}, or
\code{"domain"}. Read more about \link[=team_drives]{Team Drives}.}

\item{verbose}{Logical, indicating whether to print informative messages
(default \code{TRUE}).}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per item.
}
\description{
Retrieve metadata for files specified via path or via file id.

If the files are specified via \code{path}, the returned \code{\link{dribble}}
will include a \code{path} variable. To add path information to any \code{\link{dribble}}
that lacks it, use \code{\link[=drive_reveal]{drive_reveal()}}, e.g., \code{drive_reveal(d, "path")}. If
you want to list the contents of a folder, use \code{\link[=drive_ls]{drive_ls()}}. For general
searching, use \code{\link[=drive_find]{drive_find()}}.

Note: \href{https://gsuite.google.com/learning-center/products/drive/get-started-team-drive/}{Team Drives}
are only available to users of certain enhanced Google services, such as G
Suite Enterprise, G Suite Business, or G Suite for Education.
}
\section{Special considerations for paths}{

Note that Google Drive does NOT behave like your local file system:
\itemize{
\item File and folder names need not be unique, even at a given level of
the hierarchy. A single name or file path can be associated with multiple
files (or zero or exactly one).
\item A file can have more than one direct parent. This implies that a
single file can be represented by multiple paths.
}

Bottom line: Do not assume there is a one-to-one relationship between file
name or path and a Drive file or folder. This implies the length of the input
(i.e. the number of input paths or the number of rows in a dribble) will not
necessarily equal the number rows in the output.
}

\examples{
\dontrun{
## get info about your "My Drive" root folder
drive_get("~/")
## the API reserves the file id "root" for your root folder
drive_get(id = "root")
drive_get(id = "root") \%>\% drive_reveal("path")

## multiple names
drive_get(c("abc", "def"))

## multiple names, one of which must be a folder
drive_get(c("abc", "def/"))

## query by file id(s)
drive_get(id = "abcdefgeh123456789")
drive_get(as_id("abcdefgeh123456789"))
drive_get(id = c("abcdefgh123456789", "jklmnopq123456789"))

## access the Team Drive named "foo"
## team_drive params must be specified if getting by path
foo <- team_drive_get("foo")
drive_get(c("this.jpg", "that-file"), team_drive = foo)
## team_drive params are not necessary if getting by id
drive_get(as_id("123456789"))

## search all Team Drives and other files user has accessed
drive_get(c("this.jpg", "that-file"), corpus = "all")
}
}
\seealso{
Wraps the \code{files.get} endpoint and, if you specify files by name or
path, also calls \code{files.list}:
\itemize{
\item \url{https://developers.google.com/drive/v3/reference/files/update}
\item \url{https://developers.google.com/drive/v3/reference/files/list}
}
}
