% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_download.R
\name{drive_download}
\alias{drive_download}
\title{Download a Drive file}
\usage{
drive_download(file, path = NULL, type = NULL, overwrite = FALSE,
  verbose = TRUE)
}
\arguments{
\item{file}{Something that identifies the file of interest on your Google
Drive. Can be a name or path, a file id or URL marked with
\code{\link{as_id}()}, or a \code{\link{dribble}}.}

\item{path}{Character. Path for output file. If absent, the default file name
is the file's name on Google Drive and the default location is working
directory, possibly with an added file extension.}

\item{type}{Character. Only consulted if \code{file} is a native Google file.
Specifies the desired type of the downloaded file. Will be processed via
\code{\link[=drive_mime_type]{drive_mime_type()}}, so either a file extension like \code{"pdf"} or a full MIME
type like \code{"application/pdf"} is acceptable.}

\item{overwrite}{A logical scalar. If \code{path} already exists, do you want to
overwrite it?}

\item{verbose}{Logical, indicating whether to print informative messages
(default \code{TRUE}).}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per
  item.
}
\description{
This function downloads a file from Google Drive. Native Google
file types, such as Google Docs, Google Sheets, and Google Slides, must be
exported to a conventional local file type. This can be specified:
\itemize{
\item explicitly via \code{type}
\item implicitly via the file extension of \code{path}
\item not at all, i.e. rely on default built into googledrive
}

To see what export file types are even possible, see the
\href{https://developers.google.com/drive/v3/web/manage-downloads#downloading_google_documents}{Drive API documentation}.
Returned dribble contains local path to downloaded file in \code{local_path}.
}
\examples{
\dontrun{
## Upload a csv file into a Google Sheet
file <- drive_upload(
  drive_example("chicken.csv"),
  type = "spreadsheet"
  )

## Download Sheet as csv, explicit type
(downloaded_file <- drive_download(file, type = "csv"))

## See local path to new file
downloaded_file$local_path

## Download as csv, type implicit in file extension
drive_download(file, path = "my_csv_file.csv")

## Download with default name and type (xlsx)
drive_download(file)

## Clean up
unlink(c("chicken.csv", "chicken.csv.xlsx", "my_csv_file.csv"))
drive_rm(file)
}
}
