% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qn_to_wv}
\alias{qn_to_wv}
\title{Quantisation Noise to WV}
\usage{
qn_to_wv(q2, tau)
}
\arguments{
\item{q2}{A \code{double} corresponding to variance of drift}

\item{tau}{A \code{vec} containing the scales e.g. 2^tau}
}
\value{
A \code{vec} containing the wavelet variance of the QN.
}
\description{
This function compute the WV (haar) of a Quantisation Noise (QN) process
}
\examples{
x.sim = 1:1000
ntau = floor(log(length(x.sim),2))
tau = 2^(1:ntau)
wv.theo = qn_to_wv(1, tau)
plot(tau, wv.theo, col = "red")
}

