% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection_methods.R
\name{output.format}
\alias{output.format}
\title{Formats the rank.models (auto.imu) object}
\usage{
output.format(out, model.names, scales, N, alpha, robust, eff, B, G, seed,
  freq = 1)
}
\arguments{
\item{out}{A \code{list} containing the model matrix}

\item{model.names}{A \code{character vector} that contains the names of the models fit.}

\item{scales}{A \code{vector} containing the 2^(1:J) scales.}

\item{N}{A \code{int} indicating the length of the time series.}

\item{alpha}{A \code{double} indicating the CI confidence.}

\item{robust}{A \code{bool} indicating whether to use robust (T) or to use classical (F)}

\item{eff}{A \code{double} indicating the efficiency for robust estimation.}

\item{B}{A \code{int} to indicate how many bootstraps should occur when generating the V matrix.}

\item{G}{A \code{int} to indicate how many guesses should be performed during the grid search}

\item{seed}{A \code{seed} to recreate the same GMWM estimator results.}

\item{freq}{A \code{double} that represents the frequency between observations.}
}
\value{
An updated matrix in the ith position of the list.
}
\description{
Creates the correct GMWM object and rank.models (auto.imu) summary object
}
\keyword{internal}

