% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{derivative_first_matrix}
\alias{derivative_first_matrix}
\title{Analytic D matrix of Processes}
\usage{
derivative_first_matrix(theta, desc, objdesc, tau)
}
\arguments{
\item{theta}{A \code{vec} containing the list of estimated parameters.}

\item{desc}{A \code{vector<string>} containing a list of descriptors.}

\item{objdesc}{A \code{field<vec>} containing a list of object descriptors.}

\item{tau}{A \code{vec} containing the scales e.g. 2^(1:J)}
}
\value{
A \code{matrix} with the process derivatives going down the column
}
\description{
This function computes each process to WV (haar) in a given model.
}
\details{
Function returns the matrix effectively known as "D"
}
\examples{
mod = AR1(.4,1) + WN(.2) + DR(.005)
derivative_first_matrix(mod$theta, mod$desc, mod$obj.desc, 2^(1:9))
}
\author{
JJB
}

