% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMWM.R
\name{compare.models}
\alias{compare.models}
\title{Graphically Compare GMWM Models Constructed by the Same Data}
\usage{
compare.models(..., display.model = T, background = "white",
  transparence = 0.1, CI.color = "#003C7D", line.color = NULL,
  line.type = NULL, point.size = NULL, point.shape = NULL,
  title = "Comparison of GMWM Models", title.size = 18,
  axis.label.size = 16, axis.tick.size = 11, facet.label.size = 13,
  facet.label.background = "#003C7D33",
  axis.x.label = expression(paste("Scale ", tau)),
  axis.y.label = expression(paste("Wavelet Variance ", nu)))
}
\arguments{
\item{...}{Several \code{gmwm} objects, and they must be constrcuted by the same data.}

\item{display.model}{A \code{boolean} indicating whether the model should be displayed in the facet label.}

\item{background}{A \code{string} that determines the graph background. It can be \code{'grey'} or \code{'white'}.}

\item{transparence}{A \code{double} that ranges from 0 to 1 that controls the transparency of confidence interval.}

\item{CI.color}{A \code{string} that indicates the color of the confidence interval (e.g. 'black', 'red', '#003C7D', etc.)}

\item{line.color}{A \code{vector} of \code{string} that indicates the color of lines.}

\item{line.type}{A \code{vector} of \code{string} that indicates the type of lines.}

\item{point.size}{A \code{vector} of \code{integer} that indicates the size of points on lines.}

\item{point.shape}{A \code{vector} of \code{integer} that indicates the shape of points on lines.}

\item{title}{A \code{string} that indicates the title of the graph.}

\item{title.size}{An \code{integer} that indicates the size of title.}

\item{axis.label.size}{An \code{integer} that indicates the size of label.}

\item{axis.tick.size}{An \code{integer} that indicates the size of tick mark.}

\item{facet.label.size}{An \code{integer} that indicates the size of facet label.}

\item{facet.label.background}{A \code{string} that indicates the background color of the facet label.}

\item{axis.x.label}{A \code{string} that indicates the label on x axis.}

\item{axis.y.label}{A \code{string} that indicates the label on y axis.}
}
\description{
Creates a table of graphs to compare GMWM model fits.
}
\details{
This function only works for \code{gmwm} objects which are constrcuted by same data, and 
all \code{gmwm} objects must be constructed by classical method, or by robust methods
with the same efficiency. That's because this function assumes each \code{gmwm} object has the same empirical wavelet variance (WV).
This function will check whether this requirement is satisfied before plotting the graph.

The value of \code{line.type}, \code{line.color}, \code{point.size}, \code{point.size} must be a \code{vector}. Please follow this order:
"Empirical WV, lower bound of CI, higher bound of CI, model1 implied WV, model2 implied WV, ...."

Please check examples for help.

If you meet the error "polygon edge not found", it is complaining that you don't have enough space to
plot the graph. Adjust the plot window.
}
\examples{
\dontrun{
if(!require("imudata")){
   install_imudata()
   library("imudata")
}

data(imu6)

model1 = gmwm.imu(3*AR1(),imu6[,2])
model2 = gmwm.imu(2*AR1() + RW(),imu6[,2])
compare.models(model1, model2)
compare.models(model1, model2, display.model = F, point.size = c(4, 0, 0, 4, 4))
compare.models(model1, model2, transparence = 0.2, 
               line.color = c('black', 'grey', 'grey', 'blue', 'red'))
}
}
\author{
Wenchao
}

