% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.model.R
\name{MA}
\alias{MA}
\title{Create an Moving Average Q [MA(Q)] Process}
\usage{
MA(theta = NULL, sigma2 = 1)
}
\arguments{
\item{theta}{A \code{vector} with double values for the \eqn{\theta}{theta} of an MA(Q) process.}

\item{sigma2}{A \code{double} value for the variance, \eqn{\sigma ^2}{sigma^2}, of a WN process.}
}
\value{
An S3 object with called ts.model with the following structure:
\itemize{
 \item{process.desc}{Used in summary: "MA-1","MA-2", ..., "MA-Q", "SIGMA2"}
 \item{theta}{\eqn{\theta_1}{theta[[1]]}, \eqn{\theta_2}{theta[[2]]}, ..., \eqn{\theta_q}{theta[[q]]}, \eqn{\sigma^2}{sigma^2}}
 \item{plength}{Number of Parameters}
 \item{desc}{"MA"}
 \item{obj.desc}{Depth of Parameters e.g. list(q,1)}
 \item{starting}{Guess Starting values? TRUE or FALSE (e.g. specified value)}
}
}
\description{
Setups the necessary backend for the MA(Q) process.
}
\examples{
MA(1) # One theta
MA(2) # Two thetas!

MA(theta=.32, sigma=1.3) # 1 theta with a specific value.
MA(theta=c(.3,.5), sigma=.3) # 2 thetas with specific values.
}
\author{
JJB
}

