% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSMVARconstruction.R
\name{update_numtols}
\alias{update_numtols}
\title{Update the stationarity and positive definiteness numerical tolerances of an
  existing class 'gsmvar' model.}
\usage{
update_numtols(gsmvar, stat_tol = 0.001, posdef_tol = 1e-08, df_tol = 1e-08)
}
\arguments{
\item{gsmvar}{an object of class \code{'gsmvar'}, typically created with \code{fitGSMVAR} or \code{GSMVAR}.}

\item{stat_tol}{numerical tolerance for stationarity of the AR parameters: if the "bold A" matrix of any regime
has eigenvalues larger that \code{1 - stat_tol} the model is classified as non-stationary. Note that if the
tolerance is too small, numerical evaluation of the log-likelihood might fail and cause error.}

\item{posdef_tol}{numerical tolerance for positive definiteness of the error term covariance matrices: if
the error term covariance matrix of any regime has eigenvalues smaller than this, the model is classified
as not satisfying positive definiteness assumption. Note that if the tolerance is too small, numerical
evaluation of the log-likelihood might fail and cause error.}

\item{df_tol}{the parameter vector is considered to be outside the parameter space if all degrees of
freedom parameters are not larger than \code{2 + df_tol}.}
}
\value{
Returns an object of class \code{'gsmvar'} defining a structural GSMVAR model with the modified
  structural parameters and constraints.
}
\description{
\code{update_numtols} updates the stationarity and positive definiteness
  numerical tolerances of an existing class 'gsmvar' model.
}
\details{
All signs in any column of \eqn{W} can be swapped without changing the implied reduced form model.
  Consequently, also the signs in the columns of the B-matrix are swapped. Note that the sign constraints
  imposed on \eqn{W} (or the B-matrix) are also swapped in the corresponding columns accordingly.

  Also the order of the columns of \eqn{W} can be changed (without changing the implied reduced
  form model) as long as the order of lambda parameters is also changed accordingly. This can be
  done with the function \code{reorder_W_columns}.
}
\examples{
# Structural GMVAR(2, 2), d=2 model identified with sign-constraints:
params22s <- c(0.36, 0.121, 0.484, 0.072, 0.223, 0.059, -0.151, 0.395,
  0.406, -0.005, 0.083, 0.299, 0.218, 0.02, -0.119, 0.722, 0.093, 0.032,
  0.044, 0.191, 0.057, 0.172, -0.46, 0.016, 3.518, 5.154, 0.58)
W_22 <- matrix(c(1, 1, -1, 1), nrow=2, byrow=FALSE)
mod22s <- GSMVAR(p=2, M=2, d=2, params=params22s, structural_pars=list(W=W_22))
mod22s

# Update numerical tolerances:
mod22s <- update_numtols(mod22s, stat_tol=1e-4, posdef_tol=1e-9, df_tol=1e-10)
mod22s # The same model
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2022. Structural Gaussian mixture vector autoregressive model with application to the asymmetric
     effects of monetary policy shocks. Unpublished working paper, available as arXiv:2007.04713.
   \item Virolainen S. 2022. Gaussian and Student's t mixture vector autoregressive model with application to the
     asymmetric effects of monetary policy shocks in the Euro area. Unpublished working
     paper, available as arXiv:2109.13648.
 }
 @keywords internal
}
\seealso{
\code{\link{fitGSMVAR}}, \code{\link{GSMVAR}}, \code{\link{GIRF}}, \code{\link{reorder_W_columns}},
 \code{\link{gsmvar_to_sgsmvar}}, \code{\link{stmvar_to_gstmvar}}
}
