% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaldAndLR.R
\name{Wald_test}
\alias{Wald_test}
\title{Perform Wald test for a GMVAR or SGMVAR model}
\usage{
Wald_test(gmvar, A, c, h = 6e-06)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}

\item{A}{a size \eqn{(k x n_params)} matrix with full row rank specifying part of the null hypothesis
where \eqn{n_params} is the number of parameters in the (unconstrained) model.
See details for more information.}

\item{c}{a length \eqn{k} vector specifying part of the null hypothesis. See details for more information.}

\item{h}{difference used to approximate the derivatives.}
}
\value{
A list with class "htest" containing the following components:
  \item{statistic}{the value of the Wald statistics.}
  \item{parameter}{the degrees of freedom of the Wald statistic.}
  \item{p.value}{the p-value of the test.}
  \item{alternative}{a character string describing the alternative hypothesis.}
  \item{method}{a character string indicating the type of the test (Wald test).}
  \item{data.name}{a character string giving the names of the supplied model, constraint matrix A, and vector c.}
  \item{gmvar}{the supplied argument gmvar.}
  \item{A}{the supplied argument A.}
  \item{c}{the supplied argument c.}
  \item{h}{the supplied argument h.}
}
\description{
\code{Wald_test} performs a Wald test for a GMVAR or SGMVAR model
}
\details{
Denoting the true parameter value by \eqn{\theta_{0}}, we test the null hypothesis \eqn{A\theta_{0}=c}.
  Under the null, the test statistic is asymptotically \eqn{\chi^2}-distributed with \eqn{k}
  (\code{=nrow(A)}) degrees of freedom. The parameter \eqn{\theta_{0}} is assumed to have the same form as in
  the model supplied in the argument \code{gmvar} and it is presented in the documentation of the argument
  \code{params} in the function \code{GMVAR} (see \code{?GMVAR}).

  Finally, note that this function does \strong{not} check whether the specified constraints are feasible (e.g. whether
  the implied constrained model would be stationary or have positive definite error term covariance matrices).
}
\examples{
\donttest{
 # Structural GMVAR(2, 2), d=2 model with recursive identification
 W22 <- matrix(c(1, NA, 0, 1), nrow=2, byrow=FALSE)
 fit22s <- fitGMVAR(gdpdef, p=2, M=2, structural_pars=list(W=W22),
                    ncalls=1, seeds=2)
 fit22s

 # Test whether the lambda parameters (of the second regime) are identical
 # (due to the zero constraint, the model is identified under the null):
 # fit22s has parameter vector of length 26 with the lambda parameters
 # in elements 24 and 25.
 A <- matrix(c(rep(0, times=23), 1, -1, 0), nrow=1, ncol=26)
 c <- 0
 Wald_test(fit22s, A=A, c=c)

 # Test whether the off-diagonal elements of the first regime's first
 # AR coefficient matrix (A_11) are both zero:
 # fit22s has parameter vector of length 26 and the off-diagonal elements
 # of the 1st regime's 1st AR coefficient matrix are in the elements 6 and 7.
 A <- rbind(c(rep(0, times=5), 1, rep(0, times=20)),
            c(rep(0, times=6), 1, rep(0, times=19)))
 c <- c(0, 0)
 Wald_test(fit22s, A=A, c=c)
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
 @keywords internal
}
\seealso{
\code{\link{LR_test}}, \code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{diagnostic_plot}},
 \code{\link{profile_logliks}}, \code{\link{quantile_residual_tests}}, \code{\link{cond_moment_plot}}
}
