% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_duplicate.R
\name{delete_duplicate}
\alias{delete_duplicate}
\title{Delete duplicate data}
\usage{
delete_duplicate(oTree)
}
\arguments{
\item{oTree}{A list of data frames that were created 
by \code{\link{import_otree}}.}
}
\value{
This function returns a duplicate of the original oTree
list of data frames but without duplicate rows in all app data
frames and \code{$all_apps_wide}. This function has no effect on the data
frames \code{$Time} and \code{$Chats}.

This function does NOT add information to \code{$info$deleted_cases},
because it does not delete any important information but only
cleans up a messy data import.

However, the function adjusts \code{$info$initial_n}, if 
an \code{$all_apps_wide} data frame exists.
}
\description{
Delete duplicate rows from all oTree app data frames 
and \code{$all_apps_wide}.
}
\examples{
\dontshow{if (rlang::is_installed("withr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Set data folder first
withr::with_dir(system.file("extdata", package = "gmoTree"), {

# Import all oTree files in this folder and its subfolders
oTree <- import_otree()
})

# First, show some row numbers
print(paste(nrow(oTree$all_apps_wide), nrow(oTree$survey),
nrow(oTree$Time), nrow(oTree$Chats)))

# Delete duplicate rows
oTree <- delete_duplicate(oTree)

# Show row numbers again
print(paste(nrow(oTree$all_apps_wide), nrow(oTree$survey),
nrow(oTree$Time), nrow(oTree$Chats)))
\dontshow{\}) # examplesIf}
}
\keyword{oTree}
