\name{elementwise binary operators}
\docType{methods}

\alias{*-methods}
\alias{*,gmatrix,gmatrix-method}
\alias{*,gmatrix,gvector-method}
\alias{*,gmatrix,logical-method}
\alias{*,gmatrix,matrix-method}
\alias{*,gmatrix,numeric-method}
\alias{*,gvector,gmatrix-method}
\alias{*,gvector,gvector-method}
\alias{*,gvector,logical-method}
\alias{*,gvector,matrix-method}
\alias{*,gvector,numeric-method}
\alias{*,logical,gmatrix-method}
\alias{*,logical,gvector-method}
\alias{*,matrix,gmatrix-method}
\alias{*,matrix,gvector-method}
\alias{*,numeric,gmatrix-method}
\alias{*,numeric,gvector-method}

\alias{+-methods}
\alias{+,gmatrix,gmatrix-method}
\alias{+,gmatrix,gvector-method}
\alias{+,gmatrix,logical-method}
\alias{+,gmatrix,matrix-method}
\alias{+,gmatrix,missing-method}
\alias{+,gmatrix,numeric-method}
\alias{+,gvector,gmatrix-method}
\alias{+,gvector,gvector-method}
\alias{+,gvector,logical-method}
\alias{+,gvector,matrix-method}
\alias{+,gvector,missing-method}
\alias{+,gvector,numeric-method}
\alias{+,logical,gmatrix-method}
\alias{+,logical,gvector-method}
\alias{+,matrix,gmatrix-method}
\alias{+,matrix,gvector-method}
\alias{+,numeric,gmatrix-method}
\alias{+,numeric,gvector-method}

\alias{--methods}
\alias{-,gmatrix,gmatrix-method}
\alias{-,gmatrix,gvector-method}
\alias{-,gmatrix,logical-method}
\alias{-,gmatrix,matrix-method}
\alias{-,gmatrix,missing-method}
\alias{-,gmatrix,numeric-method}
\alias{-,gvector,gmatrix-method}
\alias{-,gvector,gvector-method}
\alias{-,gvector,logical-method}
\alias{-,gvector,matrix-method}
\alias{-,gvector,missing-method}
\alias{-,gvector,numeric-method}
\alias{-,logical,gmatrix-method}
\alias{-,logical,gvector-method}
\alias{-,matrix,gmatrix-method}
\alias{-,matrix,gvector-method}
\alias{-,numeric,gmatrix-method}
\alias{-,numeric,gvector-method}

\alias{/-methods}
\alias{/,gmatrix,gmatrix-method}
\alias{/,gmatrix,gvector-method}
\alias{/,gmatrix,logical-method}
\alias{/,gmatrix,matrix-method}
\alias{/,gmatrix,numeric-method}
\alias{/,gvector,gmatrix-method}
\alias{/,gvector,gvector-method}
\alias{/,gvector,logical-method}
\alias{/,gvector,matrix-method}
\alias{/,gvector,numeric-method}
\alias{/,logical,gmatrix-method}
\alias{/,logical,gvector-method}
\alias{/,matrix,gmatrix-method}
\alias{/,matrix,gvector-method}
\alias{/,numeric,gmatrix-method}
\alias{/,numeric,gvector-method}

\alias{^-methods}
\alias{^,gmatrix,gmatrix-method}
\alias{^,gmatrix,gvector-method}
\alias{^,gmatrix,logical-method}
\alias{^,gmatrix,matrix-method}
\alias{^,gmatrix,numeric-method}
\alias{^,gvector,gmatrix-method}
\alias{^,gvector,gvector-method}
\alias{^,gvector,logical-method}
\alias{^,gvector,matrix-method}
\alias{^,gvector,numeric-method}
\alias{^,logical,gmatrix-method}
\alias{^,logical,gvector-method}
\alias{^,matrix,gmatrix-method}
\alias{^,matrix,gvector-method}
\alias{^,numeric,gmatrix-method}
\alias{^,numeric,gvector-method}

\alias{\%\%-methods}
\alias{\%\%,gmatrix,gmatrix-method}
\alias{\%\%,gmatrix,gvector-method}
\alias{\%\%,gmatrix,logical-method}
\alias{\%\%,gmatrix,matrix-method}
\alias{\%\%,gmatrix,numeric-method}
\alias{\%\%,gvector,gmatrix-method}
\alias{\%\%,gvector,gvector-method}
\alias{\%\%,gvector,logical-method}
\alias{\%\%,gvector,matrix-method}
\alias{\%\%,gvector,numeric-method}
\alias{\%\%,logical,gmatrix-method}
\alias{\%\%,logical,gvector-method}
\alias{\%\%,matrix,gmatrix-method}
\alias{\%\%,matrix,gvector-method}
\alias{\%\%,numeric,gmatrix-method}
\alias{\%\%,numeric,gvector-method}

\alias{==-methods}
\alias{==,gmatrix,gmatrix-method}
\alias{==,gmatrix,gvector-method}
\alias{==,gmatrix,logical-method}
\alias{==,gmatrix,matrix-method}
\alias{==,gmatrix,numeric-method}
\alias{==,gvector,gmatrix-method}
\alias{==,gvector,gvector-method}
\alias{==,gvector,logical-method}
\alias{==,gvector,matrix-method}
\alias{==,gvector,numeric-method}
\alias{==,logical,gmatrix-method}
\alias{==,logical,gvector-method}
\alias{==,matrix,gmatrix-method}
\alias{==,matrix,gvector-method}
\alias{==,numeric,gmatrix-method}
\alias{==,numeric,gvector-method}

\alias{>-methods}
\alias{>,gmatrix,gmatrix-method}
\alias{>,gmatrix,gvector-method}
\alias{>,gmatrix,logical-method}
\alias{>,gmatrix,matrix-method}
\alias{>,gmatrix,numeric-method}
\alias{>,gvector,gmatrix-method}
\alias{>,gvector,gvector-method}
\alias{>,gvector,logical-method}
\alias{>,gvector,matrix-method}
\alias{>,gvector,numeric-method}
\alias{>,logical,gmatrix-method}
\alias{>,logical,gvector-method}
\alias{>,matrix,gmatrix-method}
\alias{>,matrix,gvector-method}
\alias{>,numeric,gmatrix-method}
\alias{>,numeric,gvector-method}

%\alias{<-methods}
\alias{<,gmatrix,gmatrix-method}
\alias{<,gmatrix,gvector-method}
\alias{<,gmatrix,logical-method}
\alias{<,gmatrix,matrix-method}
\alias{<,gmatrix,numeric-method}
\alias{<,gvector,gmatrix-method}
\alias{<,gvector,gvector-method}
\alias{<,gvector,logical-method}
\alias{<,gvector,matrix-method}
\alias{<,gvector,numeric-method}
\alias{<,logical,gmatrix-method}
\alias{<,logical,gvector-method}
\alias{<,matrix,gmatrix-method}
\alias{<,matrix,gvector-method}
\alias{<,numeric,gmatrix-method}
\alias{<,numeric,gvector-method}

\alias{>=-methods}
\alias{>=,gmatrix,gmatrix-method}
\alias{>=,gmatrix,gvector-method}
\alias{>=,gmatrix,logical-method}
\alias{>=,gmatrix,matrix-method}
\alias{>=,gmatrix,numeric-method}
\alias{>=,gvector,gmatrix-method}
\alias{>=,gvector,gvector-method}
\alias{>=,gvector,logical-method}
\alias{>=,gvector,matrix-method}
\alias{>=,gvector,numeric-method}
\alias{>=,logical,gmatrix-method}
\alias{>=,logical,gvector-method}
\alias{>=,matrix,gmatrix-method}
\alias{>=,matrix,gvector-method}
\alias{>=,numeric,gmatrix-method}
\alias{>=,numeric,gvector-method}

\alias{<=-methods}
\alias{<=,gmatrix,gmatrix-method}
\alias{<=,gmatrix,gvector-method}
\alias{<=,gmatrix,logical-method}
\alias{<=,gmatrix,matrix-method}
\alias{<=,gmatrix,numeric-method}
\alias{<=,gvector,gmatrix-method}
\alias{<=,gvector,gvector-method}
\alias{<=,gvector,logical-method}
\alias{<=,gvector,matrix-method}
\alias{<=,gvector,numeric-method}
\alias{<=,logical,gmatrix-method}
\alias{<=,logical,gvector-method}
\alias{<=,matrix,gmatrix-method}
\alias{<=,matrix,gvector-method}
\alias{<=,numeric,gmatrix-method}
\alias{<=,numeric,gvector-method}

\alias{!=-methods}
\alias{!=,gmatrix,gmatrix-method}
\alias{!=,gmatrix,gvector-method}
\alias{!=,gmatrix,logical-method}
\alias{!=,gmatrix,matrix-method}
\alias{!=,gmatrix,numeric-method}
\alias{!=,gvector,gmatrix-method}
\alias{!=,gvector,gvector-method}
\alias{!=,gvector,logical-method}
\alias{!=,gvector,matrix-method}
\alias{!=,gvector,numeric-method}
\alias{!=,logical,gmatrix-method}
\alias{!=,logical,gvector-method}
\alias{!=,matrix,gmatrix-method}
\alias{!=,matrix,gvector-method}
\alias{!=,numeric,gmatrix-method}
\alias{!=,numeric,gvector-method}

\alias{&-methods}
\alias{&,gmatrix,gmatrix-method}
\alias{&,gmatrix,gvector-method}
\alias{&,gmatrix,logical-method}
\alias{&,gmatrix,matrix-method}
\alias{&,gmatrix,numeric-method}
\alias{&,gvector,gmatrix-method}
\alias{&,gvector,gvector-method}
\alias{&,gvector,logical-method}
\alias{&,gvector,matrix-method}
\alias{&,gvector,numeric-method}
\alias{&,logical,gmatrix-method}
\alias{&,logical,gvector-method}
\alias{&,matrix,gmatrix-method}
\alias{&,matrix,gvector-method}
\alias{&,numeric,gmatrix-method}
\alias{&,numeric,gvector-method}

\alias{|-methods}
\alias{|,gmatrix,gmatrix-method}
\alias{|,gmatrix,gvector-method}
\alias{|,gmatrix,logical-method}
\alias{|,gmatrix,matrix-method}
\alias{|,gmatrix,numeric-method}
\alias{|,gvector,gmatrix-method}
\alias{|,gvector,gvector-method}
\alias{|,gvector,logical-method}
\alias{|,gvector,matrix-method}
\alias{|,gvector,numeric-method}
\alias{|,logical,gmatrix-method}
\alias{|,logical,gvector-method}
\alias{|,matrix,gmatrix-method}
\alias{|,matrix,gvector-method}
\alias{|,numeric,gmatrix-method}
\alias{|,numeric,gvector-method}

\alias{\%lgspadd\%}
\alias{\%lgspadd\%-methods}
\alias{\%lgspadd\%,gmatrix,gmatrix-method}
\alias{\%lgspadd\%,gmatrix,gvector-method}
\alias{\%lgspadd\%,gmatrix,logical-method}
\alias{\%lgspadd\%,gmatrix,matrix-method}
\alias{\%lgspadd\%,gmatrix,numeric-method}
\alias{\%lgspadd\%,gvector,gmatrix-method}
\alias{\%lgspadd\%,gvector,gvector-method}
\alias{\%lgspadd\%,gvector,logical-method}
\alias{\%lgspadd\%,gvector,matrix-method}
\alias{\%lgspadd\%,gvector,numeric-method}
\alias{\%lgspadd\%,logical,gmatrix-method}
\alias{\%lgspadd\%,logical,gvector-method}
\alias{\%lgspadd\%,matrix,gmatrix-method}
\alias{\%lgspadd\%,matrix,gvector-method}
\alias{\%lgspadd\%,numeric,gmatrix-method}
\alias{\%lgspadd\%,numeric,gvector-method}

\title{Binary Operators}
\description{
This page documents the operators \code{"*"}, \code{"+"}, \code{"-"}, \code{"/"}, \code{"^"}, \code{"\%\%"},
\code{"="}, \code{"<"}, \code{">"}, \code{">="}, \code{"<="}, \code{"!="}, \code{"&"} and \code{"|"}.
These are all element-wise binary operations that can be performed on a \code{gmatrix} or \code{gvector} object.
Operators work in much that same way as in R base. The command \code{e1 \%lgspadd\% e2} yields the vector
log(exp(e1)+exp(e2)) calculated in a numericaly stable way.
If one object is shorter than the other, items in the shorter object are recycled as in R base. All operations 
return a GPU object (i.e. a \code{gmatrix} or \code{gvector}). 
}
\section{Methods}{
\describe{
\item{\code{signature(e1 = "gmatrix", e2 = "gmatrix")}}{}
\item{\code{signature(e1 = "gmatrix", e2 = "gvector")}}{}
\item{\code{signature(e1 = "gmatrix", e2 = "logical")}}{}
\item{\code{signature(e1 = "gmatrix", e2 = "matrix")}}{}
\item{\code{signature(e1 = "gmatrix", e2 = "numeric")}}{}
\item{\code{signature(e1 = "gvector", e2 = "gmatrix")}}{}
\item{\code{signature(e1 = "gvector", e2 = "gvector")}}{}
\item{\code{signature(e1 = "gvector", e2 = "logical")}}{}
\item{\code{signature(e1 = "gvector", e2 = "matrix")}}{}
\item{\code{signature(e1 = "gvector", e2 = "numeric")}}{}
\item{\code{signature(e1 = "logical", e2 = "gmatrix")}}{}
\item{\code{signature(e1 = "logical", e2 = "gvector")}}{}
\item{\code{signature(e1 = "matrix", e2 = "gmatrix")}}{}
\item{\code{signature(e1 = "matrix", e2 = "gvector")}}{}
\item{\code{signature(e1 = "numeric", e2 = "gmatrix")}}{}
\item{\code{signature(e1 = "numeric", e2 = "gvector")}}{}
}}
\keyword{methods}
\section{Warning }{
The operator \%\% is known to be numericaly instable compared to the R version.
}
