% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variograms.R
\name{gsi.EVario3D}
\alias{gsi.EVario3D}
\title{Empirical variogram or covariance function in 3D}
\usage{
gsi.EVario3D(
  X,
  Z,
  Ff = rep(1, nrow(X)),
  maxdist = max(dist(X[sample(nrow(X), min(nrow(X), 1000)), ]))/2,
  lagNr = 15,
  lags = seq(from = 0, to = maxdist, length.out = lagNr + 1),
  dirvecs = t(c(1, 0, 0)),
  angtol = 90,
  maxbreadth = Inf,
  minpairs = 10,
  cov = FALSE
)
}
\arguments{
\item{X}{matrix of Nx3 columns with the geographic coordinates}

\item{Z}{matrix or data.frame of data with dimension (N,Dv)}

\item{Ff}{for variogram, matrix of basis functions with nrow(Ff)=N
(can be a N-vector of 1s; should include the vector of 1s!!);
for covariance function, a (N,Dv)-matrix or a Dv-vector giving the mean values}

\item{maxdist}{maximum lag distance to consider}

\item{lagNr}{number of lags to consider}

\item{lags}{if maxdist and lagNr are not specified, either: (a) a matrix of 2 columns giving
minimal and maximal lag distance defining the lag classes to consider, or (b) a vector of lag breaks}

\item{dirvecs}{matrix which rows are the director vectors along which variograms will be computed (these will be normalized!)}

\item{angtol}{scalar, angular tolerance applied (in degrees; defaults to 90??, ie. isotropic)}

\item{maxbreadth}{maximal breadth (in lag units) orthogonal to the lag direction (defaults to \code{Inf}, ie. not used)}

\item{minpairs}{minimal number of pairs falling in each class to consider the calculation sufficient; defaults to 10}

\item{cov}{boolean, is covariance (TRUE) or variogram (FALSE) desired? defaults to variogram}
}
\value{
An empirical variogram for the provided data. NOTE: avoid using directly gsi.* functions! They
represent either internal functions, or preliminary, not fully-tested functions. Use \code{\link{variogram}} instead.
}
\description{
compute the empirical variogram or covariance function in a 3D case study
}
\seealso{
Other gmEVario functions: 
\code{\link{as.gmEVario}()},
\code{\link{gsi.EVario2D}()},
\code{\link{ndirections}()},
\code{\link{plot.gmEVario}()},
\code{\link{variogramModelPlot}()}
}
\concept{gmEVario functions}
