% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask.R
\name{getMask}
\alias{getMask}
\alias{getMask.default}
\alias{getMask.SpatialPixelsDataFrame}
\alias{getMask.SpatialPixels}
\alias{getMask.SpatialPointsDataFrame}
\title{Get the mask info out of a spatial data object}
\usage{
getMask(x)

\method{getMask}{default}(x)

\method{getMask}{SpatialPixelsDataFrame}(x)

\method{getMask}{SpatialPixels}(x)

\method{getMask}{SpatialPointsDataFrame}(x)
}
\arguments{
\item{x}{a masked object}
}
\value{
The retrieved mask information from \code{x}, an object of class "mask"
}
\description{
Retrieve the mask information from an object (if present). See \code{\link[=constructMask]{constructMask()}}
for examples.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Get the mask info out of a spatial data object

\item \code{SpatialPixelsDataFrame}: Get the mask info out of a SpatialPixelsDataFrame data object

\item \code{SpatialPixels}: Get the mask info out of a SpatialPixels object

\item \code{SpatialPointsDataFrame}: Get the mask info out of a SpatialPointsDataFrame data object
}}

\seealso{
Other masking functions: 
\code{\link{constructMask}()},
\code{\link{print.mask}()},
\code{\link{setMask}()},
\code{\link{unmask}()}
}
\concept{masking functions}
