% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositionsCompatibility.R
\name{variogramModelPlot.logratioVariogram}
\alias{variogramModelPlot.logratioVariogram}
\title{Quick plotting of empirical and theoretical logratio variograms
Quick and dirty plotting of empirical logratio variograms with or without their models}
\usage{
\method{variogramModelPlot}{logratioVariogram}(
  vg,
  model = NULL,
  col = rev(rainbow(ndirections(vg))),
  commonAxis = FALSE,
  newfig = FALSE,
  ...
)
}
\arguments{
\item{vg}{empirical variogram or covariance function}

\item{model}{optional, theoretical variogram or covariance function}

\item{col}{colors to use for the several directional variograms}

\item{commonAxis}{boolean, should all plots in a row share the same vertical axis?}

\item{newfig}{boolean, should a new figure be created? otherwise user should ensure the device space is appropriately managed}

\item{...}{further parameters to underlying plot or matplot functions}
}
\value{
The function is primarily called for producing a plot. However, it
invisibly returns the graphical parameters active before the call
occurred. This is useful for constructing complex diagrams, by adding layers
of info. If you want to "freeze" your plot, embed your call in another
call to \code{\link{par}}, e.g. \code{par(variogramModelPlot(...))}.
}
\description{
Quick plotting of empirical and theoretical logratio variograms
Quick and dirty plotting of empirical logratio variograms with or without their models
}
\seealso{
Other variogramModelPlot: 
\code{\link{variogramModelPlot.gstatVariogram}()},
\code{\link{variogramModelPlot}()}
}
\concept{variogramModelPlot}
