% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Eps.R
\name{Eps}
\alias{Eps}
\title{Inverse cumulative distribution function for a subset of the dataset}
\usage{
Eps(p, data, group = "qtyvar")
}
\arguments{
\item{p}{cumulative distribution percentile}

\item{data}{dataset with defined group and newwts columns}

\item{group}{variable of interest}
}
\value{
Cumulative distribution percentile for quantile y
}
\description{
Inverse cumulative distribution function for a subset of the dataset
}
\examples{

df_samp <- data.frame(qtyvar = rnorm(1000, mean = 5, sd = 2),newwts = rep(1, 1000))
Eps(0.25,df_samp)
# Finds the quantile for 25th percentile in simulated data.
}
