% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{set_lme4_control}
\alias{set_lme4_control}
\title{Control of Mixed Model Fitting}
\usage{
set_lme4_control(check.nobs.vs.rankZ = "ignore",
  check.nobs.vs.nlev = "ignore", check.nlev.gtreq.5 = "ignore",
  check.nlev.gtr.1 = "ignore", check.nobs.vs.nRE = "ignore",
  check.rankX = c("message+drop.cols", "silent.drop.cols", "warn+drop.cols",
  "stop.deficient", "ignore"), check.scaleX = "warning",
  check.formula.LHS = "stop", check.response.not.const = "ignore", ...)
}
\arguments{
\item{check.nobs.vs.rankZ}{character - rules for
    checking whether the number of observations is greater
    than (or greater than or equal to) the rank of the random
    effects design matrix (Z), usually necessary for
    identifiable variances.  As for \code{action}, with
    the addition of \code{"warningSmall"} and \code{"stopSmall"}, which run
    the test only if the dimensions of \code{Z} are < 1e6.
    \code{nobs > rank(Z)} will be tested for LMMs and GLMMs with
    estimated scale parameters; \code{nobs >= rank(Z)} will be tested
    for GLMMs with fixed scale parameter.
    The rank test is done using the
    \code{method="qr"} option of the \code{\link[Matrix]{rankMatrix}}
    function.
  }

\item{check.nobs.vs.nlev}{ character - rules for checking whether the
    number of observations is less than (or less than or equal to) the
    number of levels of every grouping factor, usually necessary for
    identifiable variances.  As for \code{action}.
    \code{nobs<nlevels} will be tested for LMMs and GLMMs with estimated
    scale parameters; \code{nobs<=nlevels} will be tested for GLMMs with
    fixed scale parameter.}

\item{check.nlev.gtreq.5}{character - rules for
    checking whether all random effects have >= 5 levels.
    See \code{action}.}

\item{check.nlev.gtr.1}{character - rules for checking
    whether all random effects have > 1 level. See \code{action}.}

\item{check.nobs.vs.nRE}{character - rules for
    checking whether the number of observations is greater
    than (or greater than or equal to) the number of random-effects
    levels for each term, usually necessary for identifiable variances.
    As for \code{check.nobs.vs.nlev}.}

\item{check.rankX}{character - specifying if \code{\link[Matrix]{rankMatrix}(X)}
    should be compared with \code{ncol(X)} and if columns from the design
    matrix should possibly be dropped to ensure that it has full rank.
    Sometimes needed to make the model identifiable.  The options can be
    abbreviated; the three \code{"*.drop.cols"} options all do drop
    columns, \code{"stop.deficient"} gives an error when the rank is
    smaller than the number of columns where \code{"ignore"} does no
    rank computation, and will typically lead to less easily
    understandable errors, later.}

\item{check.scaleX}{character - check for problematic scaling of
    columns of fixed-effect model matrix, e.g. parameters measured on
    very different scales.}

\item{check.formula.LHS}{ check whether specified formula has
    a left-hand side. Primarily for internal use within
    \code{simulate.merMod};
    \emph{use at your own risk} as it may allow the generation
    of unstable \code{merMod} objects}

\item{check.response.not.const}{character - check that the
    response is not constant.}

\item{...}{other arguments to \code{glmerControl}}
}
\description{
A version of \code{glmerControl} from \code{lme4}, with different defaults.
}
