% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-inference.R
\name{AIC.gkwreg}
\alias{AIC.gkwreg}
\title{Akaike Information Criterion for GKw Regression Models}
\usage{
\method{AIC}{gkwreg}(object, ..., k = 2)
}
\arguments{
\item{object}{An object of class \code{"gkwreg"}, typically obtained from
\code{\link{gkwreg}}.}

\item{...}{Optionally more fitted model objects.}

\item{k}{Numeric, the penalty per parameter. Default is \code{k = 2} for
classical AIC. Setting \code{k = log(n)} gives BIC-equivalent penalty.}
}
\value{
If only one object is provided, returns a numeric value with the AIC.
If multiple objects are provided, returns a data frame with columns \code{df}
and \code{AIC}, with rows named according to the object names in the call.
}
\description{
Calculates the Akaike Information Criterion (AIC) for fitted Generalized
Kumaraswamy regression models.
}
\details{
The AIC is computed as:
\deqn{AIC = -2\ell(\hat{\theta}) + k \cdot p}
where \eqn{\ell(\hat{\theta})} is the maximized log-likelihood and \eqn{p}
is the number of estimated parameters.

When multiple objects are provided, a data frame comparing all models is
returned. Lower AIC values indicate better models, balancing goodness-of-fit
against model complexity.

For small sample sizes, consider the corrected AIC (AICc):
\deqn{AICc = AIC + \frac{2p(p+1)}{n-p-1}}
where \eqn{n} is the sample size. This correction is not automatically applied
but can be calculated manually.
}
\examples{
\donttest{
# Load example data
data(GasolineYield)

# Fit competing models
fit1 <- gkwreg(yield ~ batch, data = GasolineYield, family = "kw")
fit2 <- gkwreg(yield ~ batch + temp, data = GasolineYield, family = "kw")
fit3 <- gkwreg(yield ~ temp, data = GasolineYield, family = "kw")

# Calculate AIC for single model
AIC(fit1)

# Compare multiple models (with proper names)
AIC(fit1, fit2, fit3)

# Use different penalty
AIC(fit1, k = 4)
}

}
\references{
Akaike, H. (1974). A new look at the statistical model identification.
\emph{IEEE Transactions on Automatic Control}, \strong{19}(6), 716--723.
\doi{10.1109/TAC.1974.1100705}

Burnham, K. P., & Anderson, D. R. (2004). Multimodel inference: Understanding
AIC and BIC in model selection. \emph{Sociological Methods & Research},
\strong{33}(2), 261--304. \doi{10.1177/0049124104268644}
}
\seealso{
\code{\link{gkwreg}}, \code{\link{logLik.gkwreg}}, \code{\link{BIC.gkwreg}}
}
\author{
Lopes, J. E.
}
