% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-mask.R
\docType{data}
\name{geom_mask}
\alias{geom_mask}
\alias{GeomMask}
\title{Apply Manual Clipping Mask}
\usage{
geom_mask()
}
\description{
This function creates a manual clipping mask, which in turn suppresses the standard clipping mask that would otherwise
be rendered in the foregound rendering procedure, giving the user control over the exact placement with respect to 
other layers. For example, the user may wish to have the clipping mask placed after 
the \code{geom_point(...)} layer, but before the \code{geom_label(...)} layer, this situation has been
demonstrated in the example below. In the event that the user wishes to suppress the mask altogether, then a convenience
function has been provided, \code{theme_nomask()}.
}
\examples{
data(Feldspar)
x = ggtern(Feldspar,aes(Ab,An,Or,label=Experiment)) + geom_point()

#Default Behaviour
x + geom_label()

#Insert manual mask before the labels, to prevent them being truncated
x + geom_point(size=6) + geom_mask() + geom_label()
}
\author{
Nicholas Hamilton
}
\keyword{datasets}
