% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-tern-tlr2xy.R
\name{ternary_transformation}
\alias{ternary_transformation}
\alias{tlr2xy}
\alias{xy2tlr}
\title{Ternary / Cartesian Transformation}
\usage{
tlr2xy(data, coord, ..., inverse = FALSE, scale = TRUE, drop = FALSE)

xy2tlr(data, coord, ..., inverse = FALSE, scale = TRUE)
}
\arguments{
\item{data}{\code{data.frame} containing columns as required by the coordinate system. 
Data will be scaled so that the rows sum to unity, in the event that the user has provided 
data that does not.}

\item{coord}{Coordinate system object, inheriting the \code{\link{CoordTern}} class, error will
be thrown if a different coordinate system is sent to this method}

\item{...}{not used}

\item{inverse}{logical if we are doing a forward (FALSE) or reverse (TRUE) transformation}

\item{scale}{logical as to whether the transformed coordinates are scaled (or reverse scaled in the case of inverse 
transformation) according to the training routine defined in the coordinate system.}

\item{drop}{drop all non columns which are not involved in the transformation}
}
\description{
Functions to transform data from the ternary to cartesian spaces and vice-versa.
}
\details{
\code{tlr2xy} transforms from the ternary to cartesian spaces, an inverse transformation 
transforms between cartesian to ternary spaces

\code{xy2tlr} transforms from the cartesian to ternary spaces, an inverse transformation 
transforms between ternary to cartesian spaces, it is the reciprocal to \code{\link{tlr2xy}}, therefore
an inverse transformation in \code{\link{xy2tlr}} function is the same as the forward 
transformation in \code{\link{tlr2xy}}
}
\examples{
data(Feldspar)
dfm = plyr::rename(Feldspar,c("Ab"="x","An"="y","Or"="z"))
crd = coord_tern()
fwd = tlr2xy(dfm,crd)
rev = tlr2xy(fwd,crd,inverse = TRUE)
}
\author{
Nicholas Hamilton
}

