% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-shadowpoint.r
\name{geom_shadowpoint}
\alias{geom_shadowpoint}
\title{Points}
\usage{
geom_shadowpoint(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by [aes()] or
[aes_()]. If specified and `inherit.aes = TRUE` (the
default), it is combined with the default mapping at the top level of the
plot. You must supply `mapping` if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If `NULL`, the default, the data is inherited from the plot
   data as specified in the call to [ggplot()].

   A `data.frame`, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   [fortify()] for which variables will be created.

   A `function` will be called with a single argument,
   the plot data. The return value must be a `data.frame`, and
   will be used as the layer data. A `function` can be created
   from a `formula` (e.g. `~ head(.x, 10)`).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to [layer()]. These are
often aesthetics, used to set an aesthetic to a fixed value, like
`colour = "red"` or `size = 3`. They may also be parameters
to the paired geom/stat.}

\item{na.rm}{If `FALSE`, the default, missing values are removed with
a warning. If `TRUE`, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
`NA`, the default, includes if any aesthetics are mapped.
`FALSE` never includes, and `TRUE` always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If `FALSE`, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. [borders()].}
}
\value{
a layer to add to a plot.
}
\description{
The point geom is used to create scatterplots. [geom_shadowpoint()] is
designed as a drop in replacement for [geom_point()] with an added shadow beneath
the point to make a busy plot more aesthetically appealing or to make points
stand out from the rest of the plot.
}
\section{Aesthetics}{

Adds 3 new aesthetics to [geom_point()]:
* \code{shadowcolour} defaults to white, controls the color of the shadow.
* \code{shadowsize} defaults to \code{1.8 * size}, controls the sie of the shadow.
* \code{shadowalpha} defaults to \code{0.25 * alpha} or \code{0.9}, controls the alpha of the shadow.
}

\examples{
library( ggplot2 )
p <- ggplot(mtcars, aes(wt, mpg))
p + geom_shadowpoint()

}
