% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-cosmic.R
\name{pal_cosmic}
\alias{pal_cosmic}
\title{COSMIC Color Palettes}
\usage{
pal_cosmic(
  palette = c("hallmarks_light", "hallmarks_dark", "signature_substitutions"),
  alpha = 1
)
}
\arguments{
\item{palette}{Palette type. Currently there are three available options:
\code{"signature_substitutions"} (6-color palette),
\code{"hallmarks_light"} (10-color palette), and \code{"hallmarks_dark"}
(10-color palette). The \code{"hallmarks_light"} option is from
\href{https://pubmed.ncbi.nlm.nih.gov/21376230/}{Hanahan and Weinberg (2011)}.}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices]{rgb}} for details.}
}
\description{
Color palettes inspired by the colors used in projects from the
\href{https://cancer.sanger.ac.uk/cosmic}{Catalogue Of
Somatic Mutations in Cancers (COSMIC)}
}
\examples{
library("scales")
show_col(pal_cosmic("hallmarks_light")(10))
show_col(pal_cosmic("hallmarks_light", alpha = 0.6)(10))
show_col(pal_cosmic("hallmarks_dark")(10))
show_col(pal_cosmic("hallmarks_dark", alpha = 0.6)(10))
show_col(pal_cosmic("signature_substitutions")(6))
show_col(pal_cosmic("signature_substitutions", alpha = 0.6)(6))
}
\author{
Joshua H. Cook <\email{joshuacook0023@gmail.com}> |
<\href{https://github.com/jhrcook}{GitHub/jhrcook}>
}
