% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_pwc.R
\name{stat_pwc}
\alias{stat_pwc}
\alias{geom_pwc}
\title{Add Pairwise Comparisons P-values to a GGPlot}
\usage{
stat_pwc(
  mapping = NULL,
  data = NULL,
  method = "wilcox_test",
  method.args = list(),
  ref.group = NULL,
  label = "p.format",
  y.position = NULL,
  group.by = NULL,
  dodge = 0.8,
  bracket.nudge.y = 0.05,
  bracket.shorten = 0,
  bracket.group.by = c("x.var", "legend.var"),
  step.increase = 0.12,
  tip.length = 0.03,
  size = 0.3,
  label.size = 3.88,
  family = "",
  vjust = 0,
  hjust = 0.5,
  p.adjust.method = "holm",
  p.adjust.by = c("group", "panel"),
  symnum.args = list(),
  hide.ns = FALSE,
  remove.bracket = FALSE,
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  parse = FALSE,
  ...
)

geom_pwc(
  mapping = NULL,
  data = NULL,
  stat = "pwc",
  method = "wilcox_test",
  method.args = list(),
  ref.group = NULL,
  label = "p.format",
  y.position = NULL,
  group.by = NULL,
  dodge = 0.8,
  stack = FALSE,
  step.increase = 0.12,
  tip.length = 0.03,
  bracket.nudge.y = 0.05,
  bracket.shorten = 0,
  bracket.group.by = c("x.var", "legend.var"),
  size = 0.3,
  label.size = 3.88,
  family = "",
  vjust = 0,
  hjust = 0.5,
  p.adjust.method = "holm",
  p.adjust.by = c("group", "panel"),
  symnum.args = list(),
  hide.ns = FALSE,
  remove.bracket = FALSE,
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  parse = FALSE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{method}{a character string indicating which method to be used for
pairwise comparisons. Default is \code{"wilcox_test"}. Allowed methods
include pairwise comparisons methods implemented in the \code{rstatix} R
package. These methods are: \code{"wilcox_test", "t_test", "sign_test",
"dunn_test", "emmeans_test", "tukey_hsd", "games_howell_test"}.}

\item{method.args}{a list of additional arguments used for the test method.
For example one might use \code{method.args = list(alternative = "greater")}
for wilcoxon test.}

\item{ref.group}{a character string or a numeric value specifying the
 reference group. If specified, for a given grouping variable, each of the
 group levels will be compared to the reference group (i.e. control group).

 \code{ref.group} can be also \code{"all"}. In this case, each of the
 grouping variable levels is compared to all (i.e. basemean).

 Allowed values can be: \itemize{ \item \strong{numeric value}: specifying
 the rank of the reference group. For example, use \code{ref.group = 1} when
 the first group is the reference; use \code{ref.group = 2} when the second
 group is the reference, and so on. This works for all situations, including
 i) when comparisons are performed between x-axis groups and ii) when
 comparisons are performed between legend groups. \item \strong{character
 value}: For example, you can use \code{ref.group = "ctrl"} instead of using
 the numeric rank value of the "ctrl" group. \item \strong{"all"}: In this
 case, each of the grouping variable levels is compared to all (i.e.
 basemean). }}

\item{label}{character string specifying label. Can be: \itemize{ \item the
column containing the label (e.g.: \code{label = "p"} or \code{label =
"p.adj"}), where \code{p} is the p-value. Other possible values are
\code{"p.signif", "p.adj.signif", "p.format", "p.adj.format"}. \item an
expression that can be formatted by the \code{\link[glue]{glue}()} package.
For example, when specifying \code{label = "Wilcoxon, p = \{p\}"}, the
expression \{p\} will be replaced by its value. \item a combination of
plotmath expressions and glue expressions. You may want some of the
statistical parameter in italic; for example:\code{label = "Wilcoxon,
italic(p)= {p}"}}.}

\item{y.position}{numeric vector with the y positions of the brackets}

\item{group.by}{(optional) character vector specifying the grouping variable;
it should be used only for grouped plots. Possible values are : \itemize{
\item \code{"x.var"}: Group by the x-axis variable and perform the test
between legend groups. In other words, the p-value is compute between legend
groups at each x position \item \code{"legend.var"}: Group by the legend
variable and perform the test between x-axis groups. In other words, the
test is performed between the x-groups for each legend level. }}

\item{dodge}{dodge width for grouped ggplot/test. Default is 0.8. It's used to
dodge the brackets position when \code{group.by = "legend.var"}.}

\item{bracket.nudge.y}{Vertical adjustment to nudge brackets by (in fraction
of the total height). Useful to move up or move down the bracket. If
positive value, brackets will be moved up; if negative value, brackets are
moved down.}

\item{bracket.shorten}{a small numeric value in [0-1] for shortening the width
of bracket.}

\item{bracket.group.by}{(optional); a variable name for grouping brackets
before adding step.increase. Useful for grouped plots. Possible values
include \code{"x.var"} and \code{"legend.var"}.}

\item{step.increase}{numeric vector with the increase in fraction of total
height for every additional comparison to minimize overlap.}

\item{tip.length}{numeric vector with the fraction of total height that the
bar goes down to indicate the precise column/}

\item{size}{change the width of the lines of the bracket}

\item{label.size}{change the size of the label text}

\item{family}{change the font used for the text}

\item{vjust}{move the text up or down relative to the bracket.}

\item{hjust}{move the text left or right relative to the bracket.}

\item{p.adjust.method}{method for adjusting p values (see
\code{\link[stats]{p.adjust}}).  Has impact only in a situation, where
multiple pairwise tests are performed; or when there are multiple grouping
variables. Ignored when the specified method is \code{"tukey_hsd"} or
\code{"games_howell_test"} because they come with internal p adjustment
method. Allowed values include "holm", "hochberg", "hommel", "bonferroni",
"BH", "BY", "fdr", "none". If you don't want to adjust the p value (not
recommended), use p.adjust.method = "none".}

\item{p.adjust.by}{possible value is one of \code{c("group", "panel")}.
Default is \code{"group"}: for a grouped data, if pairwise test is
performed, then the p-values are adjusted for each group level
independently. P-values are adjusted by panel when \code{p.adjust.by =
"panel"}.}

\item{symnum.args}{a list of arguments to pass to the function
 \code{\link[stats]{symnum}} for symbolic number coding of p-values. For
 example, \code{symnum.args <- list(cutpoints = c(0, 0.0001, 0.001, 0.01,
 0.05, Inf), symbols = c("****", "***", "**", "*",  "ns"))}.

 In other words, we use the following convention for symbols indicating
 statistical significance: \itemize{ \item \code{ns}: p > 0.05 \item
 \code{*}: p <= 0.05 \item \code{**}: p <= 0.01 \item \code{***}: p <= 0.001
 \item \code{****}:  p <= 0.0001 }}

\item{hide.ns}{can be logical value (\code{TRUE} or \code{FALSE}) or a character vector (\code{"p.adj"} or \code{"p"}).}

\item{remove.bracket}{logical, if \code{TRUE}, brackets are removed from the
plot. \itemize{ \item Case when logical value. If TRUE, hide ns symbol when
displaying significance levels. Filter is done by checking the column
\code{p.adj.signif}, \code{p.signif}, \code{p.adj} and \code{p}. \item Case
when character value. Possible values are "p" or "p.adj", for filtering out
non significant. }}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{parse}{logical for parsing plotmath expression.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are often
aesthetics, used to set an aesthetic to a fixed value, like \code{color =
"red"} or \code{size = 3}. They may also be parameters to the paired
geom/stat.}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{stack}{logical value. Default is FALSE; should be set to TRUE for
stacked bar plots or line plots. If TRUE, then the brackets are
automatically removed and the \code{dodge} value is set to zero.}
}
\description{
add pairwise comparison p-values to a ggplot such as box plots,
 dot plots and stripcharts.
}
\examples{
df <- ToothGrowth
df$dose <- factor(df$dose)

# Data preparation
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Transform `dose` into factor variable
df <- ToothGrowth
df$dose <- as.factor(df$dose)
# Add a random grouping variable
df$group <- factor(rep(c("grp1", "grp2"), 30))
head(df, 3)


# Two groups by x position
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%

# Create a box plot
# Add 10\% spaces between the p-value labels and the plot border
bxp <- ggboxplot(
  df, x = "dose", y = "len",
  color = "supp", palette = c("#00AFBB", "#E7B800")
) +
 scale_y_continuous(expand = expansion(mult = c(0.05, 0.10)))


# Add p-values onto the box plots
# label can be "p.format"  or "p.adj.format"
bxp + geom_pwc(
  aes(group = supp), tip.length = 0,
  method = "t_test", label = "p.format"
)

# Show adjusted p-values and significance levels
# Hide ns (non-significant)
bxp + geom_pwc(
  aes(group = supp), tip.length = 0,
  method = "t_test", label = "{p.adj.format}{p.adj.signif}",
  p.adjust.method = "bonferroni", p.adjust.by = "panel",
  hide.ns = TRUE
)

# Complex cases
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# 1. Add p-values of OJ vs VC at each dose group
bxp.complex <- bxp +
  geom_pwc(
    aes(group = supp), tip.length = 0,
    method = "t_test", label = "p.adj.format",
    p.adjust.method = "bonferroni", p.adjust.by = "panel"
  )
# 2. Add pairwise comparisons between dose levels
# Nudge up the brackets by 20\% of the total height
bxp.complex <- bxp.complex +
  geom_pwc(
    method = "t_test", label = "p.adj.format",
    p.adjust.method = "bonferroni",
    bracket.nudge.y = 0.2
  )
# 3. Display the plot
bxp.complex


# Three groups by x position
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%

# Simple plots
#_____________________________________

# Box plots with p-values
bxp <- ggboxplot(
  df, x = "supp", y = "len", fill = "dose",
  palette = "npg"
)
bxp +
  geom_pwc(
    aes(group = dose), tip.length = 0,
    method = "t_test", label = "p.adj.format",
    bracket.nudge.y = -0.08
  ) +
  scale_y_continuous(expand = expansion(mult = c(0, 0.1)))

# Bar plots with p-values
bp <- ggbarplot(
  df, x = "supp", y = "len", fill = "dose",
  palette = "npg", add = "mean_sd",
  position = position_dodge(0.8)
)
bp +
  geom_pwc(
    aes(group = dose), tip.length = 0,
    method = "t_test", label = "p.adj.format",
    bracket.nudge.y = -0.08
  ) +
  scale_y_continuous(expand = expansion(mult = c(0, 0.1)))

}
