% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpage_build.R
\name{ggpage_build}
\alias{ggpage_build}
\title{Creates a data frame for further analysis and plotting}
\usage{
ggpage_build(book, lpp = 25, character_height = 3,
  vertical_space = 1, x_space_pages = 10, y_space_pages = 10,
  nrow = NULL, ncol = NULL, bycol = TRUE, wtl = NULL,
  para.fun = NULL, page.col = NULL, align = "left", line.max = 80,
  ...)
}
\arguments{
\item{book}{Character or data.frame. Can either have each element be a
separate line or having each element being separate words.}

\item{lpp}{Numeric. Lines Per Page. Number of lines allocated for each page.}

\item{character_height}{Numeric. Relative size of the height of each letter
compared to its width.}

\item{vertical_space}{Numeric. Distance between each lines vertically.}

\item{x_space_pages}{Numeric. Distance between pages along the x-axis.}

\item{y_space_pages}{Numeric. Distance between pages along the y-axis.}

\item{nrow}{Numeric. Number of rows of pages, if omitted defaults to square
layout.}

\item{ncol}{Numeric. Number of columns of pages, if omitted defaults to
square layout.}

\item{bycol}{Logical. If TRUE (the default) the matrix is filled by
columns, otherwise the matrix is filled by rows.}

\item{wtl}{logical. If TRUE will convert single word vector into a vector
with full lines. (defaults to FALSE).}

\item{para.fun}{Function that generates random numbers to determine number
of word in each paragraph.}

\item{page.col}{column to split the pages by.}

\item{align}{Type of line alignment. Must be one of "left", "right" or "both".}

\item{line.max}{Maximal number of characters per line. Defaults to 80.}

\item{...}{Extra arguments.}
}
\value{
`data.frame` containing the following columns:
\itemize{
  \item `word`: Character. The words of the text.
  \item `page`: Integer. Page number.
  \item `line`: Integer. Line number within the page.
  \item `xmin`: Numeric. Border of rectangle, used by \code{ggpage_plot} do not
    alter.
  \item `xmax`: Numeric. Border of rectangle, used by \code{ggpage_plot} do not
    alter.
  \item `ymin`: Numeric. Border of rectangle, used by \code{ggpage_plot} do not
    alter.
  \item `ymax`: Numeric. Border of rectangle, used by \code{ggpage_plot} do not
    alter.
    }
}
\description{
This function can be used in combination with \code{ggpage_plot} to get the
same result as \code{ggpage_quick}. However by splitting the data.frame
construction and plotting we are able to do intermediate analysis which
can be included in the visualization.
}
\details{
The text MUST be presented in a column named text.
}
\examples{
\donttest{
library(dplyr)
library(stringr)
library(ggplot2)
library(tidytext)
library(ggpage)
# build and plot
## data.frame with full lines
ggpage_build(tinderbox) \%>\%
  ggpage_plot()
## vector with full lines
ggpage_build(book = tinderbox \%>\%
  pull(text)) \%>\%
  ggpage_plot()
## data.frame with single words
ggpage_build(tinderbox) \%>\%
  unnest_tokens(text, word) \%>\%
  ggpage_plot()
## vector with single words
ggpage_build(tinderbox \%>\%
  unnest_tokens(text, text) \%>\%
  pull(text)) \%>\%
  ggpage_plot()

# nrow and ncol
ggpage_build(tinderbox, nrow = 2) \%>\%
  ggpage_plot()
ggpage_build(tinderbox, ncol = 2) \%>\%
  ggpage_plot()

# Include analysis within
ggpage_build(tinderbox) \%>\%
  mutate(word_length = str_length(word)) \%>\%
  ggpage_plot(aes(fill = word_length))
}
}
